package com.bcxin.ars.rest.task;

import com.alibaba.fastjson.JSONArray;
import com.bcxin.ars.dto.AjaxResult;
import com.bcxin.ars.dto.task.BbdTaskSchedul;
import com.bcxin.ars.service.task.ComTaskSchedulService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import java.util.List;

/**
 * 任务排班制明细控制器
 *
 * @author linqinglin
 * @Date 2020-03-24 16:43:05
 */
@Controller
@RequestMapping("comTaskSchedul")
public class ComTaskSchedulController {

    Logger logger = LoggerFactory.getLogger(ComTaskSchedulController.class);

    @Autowired
    ComTaskSchedulService comTaskSchedulService;

    /**
     * 保存
     * @param persons
     * @return
     */
    @RequestMapping("save")
    @ResponseBody
    public AjaxResult save(String persons,Long comTaskId,String startDate,String endDate){
        AjaxResult result = new AjaxResult();
        try {
            List<BbdTaskSchedul> taskSchedul = JSONArray.parseArray(persons, BbdTaskSchedul.class);
            comTaskSchedulService.saveBatch(taskSchedul,comTaskId,startDate,endDate);
            result.setSuccessful(true);
            result.setMsg("操作成功");
        }catch (Exception e){
            logger.error(e.getMessage(), e);
            result.setSuccessful(false);
            throw e;
        }
        return result;
    }
}

