package com.bcxin.ars.rest.task;

import com.alibaba.fastjson.JSONObject;
import com.bcxin.ars.dto.AjaxResult;
import com.bcxin.ars.dto.task.ComShiftDto;
import com.bcxin.ars.service.task.ComShiftService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;


/**
 * 企业班次控制器
 *
 * @author linqinglin
 * @Date 2020-03-26 09:39:32
 */
@Controller
@RequestMapping("comShift")
public class ComShiftController {

    Logger logger = LoggerFactory.getLogger(ComShiftController.class);

    @Autowired
    ComShiftService comShiftService;


    /**
     * 保存
     * @param taskShiftStr
     * @return
     */
    @RequestMapping("save")
    @ResponseBody
    public AjaxResult save(String taskShiftStr){
        AjaxResult result = new AjaxResult();
        try {
            ComShiftDto comShift = JSONObject.parseObject(taskShiftStr,ComShiftDto.class);
            comShiftService.save(comShift);
            result.setSuccessful(true);
            result.setMsg("操作成功");
        }catch (Exception e){
            logger.error(e.getMessage(), e);
            result.setSuccessful(false);
            throw e;
        }
        return result;
    }

}

