package com.bcxin.ars.rest.sb;

import com.bcxin.ars.dto.AjaxResult;
import com.bcxin.ars.model.User;
import com.bcxin.ars.model.sb.Sponsorlicense;
import com.bcxin.ars.service.sb.SponsorlicenseService;
import com.bcxin.ars.service.util.ArsUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;


/**
 * 广西公安厅互联网+平台对接 保安服务公司的法定代表人设立审核申报
 * @author subh
 * @since jdk1.8
 * @see SponsorlicenseService#saveOrUpdate
 * @see ArsUtil#getCurrentUser
 */
@Controller
@RequestMapping("sponsorlicense")
public class SponsorlicenseController {

    /***
     * 日志
     */
    private Logger logger = LoggerFactory.getLogger(SponsorlicenseController.class);
    @Autowired
    private SponsorlicenseService sponsorlicenseService;

    @Autowired
    private ArsUtil arsUtil;

    /**
     * 保安服务公司的法定代表人设立审核申报新增或更新
     * @param sponsorlicense  保安服务公司的法定代表人设立审核申报数据
     * @return 返回执行结果对象
     * @throws Exception  系统异常
     */
    @RequestMapping("saveOrUpdate")
    public @ResponseBody AjaxResult saveOrUpdate(Sponsorlicense sponsorlicense) throws Exception{
        AjaxResult result = new AjaxResult();
        try {
            User user = arsUtil.getCurrentUser();
            if(user != null) {
                result.setSuccessful(true);
                sponsorlicenseService.saveOrUpdate(sponsorlicense);
            } else {
                result.setSuccessful(false);
            }
        } catch(Exception e) {
            logger.error(e.getMessage(), e);
            throw e;
        }
        return result;
    }

}
