package com.bcxin.ars.rest.manage;

import cn.hutool.core.lang.Assert;
import com.alibaba.fastjson.JSONArray;
import com.bcxin.ars.dto.AjaxResult;
import com.bcxin.ars.dto.sb.BackgroundApprovalDto;
import com.bcxin.ars.dto.sb.PersoncertificateSearchDto;
import com.bcxin.ars.enums.MinisterialDataType;
import com.bcxin.ars.model.Config;
import com.bcxin.ars.model.PageResult;
import com.bcxin.ars.model.PersonBaseInfo;
import com.bcxin.ars.model.SecurityPerson;
import com.bcxin.ars.model.sb.BackgroundApproval;
import com.bcxin.ars.model.sb.Personcertificate;
import com.bcxin.ars.model.sys.MinisterialLog;
import com.bcxin.ars.model.zw.Pctinfo;
import com.bcxin.ars.rest.util.manage.ManageResultUtil;
import com.bcxin.ars.rest.util.manage.TableResult;
import com.bcxin.ars.service.PersonAddService;
import com.bcxin.ars.service.SecurityPersonService;
import com.bcxin.ars.service.bean.factory.BackGroupCensorServiceBeanFactory;
import com.bcxin.ars.service.sb.ActivityRepairService;
import com.bcxin.ars.service.sb.BackgroundApprovalService;
import com.bcxin.ars.service.sb.PersoncertificateService;
import com.bcxin.ars.service.syncDepart.SyncDepartService;
import com.bcxin.ars.service.sys.MinisterialLogService;
import com.bcxin.ars.service.util.ConfigUtils;
import com.bcxin.ars.service.util.MinisterialUtil;
import com.bcxin.ars.service.util.thread.PersoncertificateRunnable;
import com.bcxin.ars.service.zw.PctinfoService;
import com.bcxin.ars.util.CTLUtil;
import com.bcxin.ars.util.Constants;
import com.bcxin.ars.util.StringUtil;
import com.bcxin.ars.util.thread.ThreadPoolManager;
import com.bcxin.ars.webservice.BackGroupCensorService;
import com.bcxin.ars.webservice.ClientUtil;
import com.dragonsoft.node.adapter.comm.RbspCall;
import com.dragonsoft.node.adapter.comm.RbspConsts;
import com.dragonsoft.node.adapter.comm.RbspService;
import com.google.common.collect.Maps;
import com.xiaoleilu.hutool.http.HttpResponse;
import com.xiaoleilu.hutool.http.HttpUtil;
import com.xiaoleilu.hutool.http.Method;
import net.sf.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

import javax.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 保安员证管理
 * @author linqinglin
 * @date 2019/01/11 0011 14:56
 */
@Controller
@RequestMapping("manage/personcertificate")
public class ManagePersoncertificateController {

    /***
     * 日志
     */
    private final static  Logger logger = LoggerFactory.getLogger(ManagePersoncertificateController.class);
    /***
     * 人员
     */
    @Autowired
    private SecurityPersonService securityPersonService;
    @Autowired
    private ConfigUtils configUtils;

    @Autowired
    private ActivityRepairService activityRepairService;

    @Autowired
    private PersoncertificateService personcertificateService;

    @Autowired
    private BackgroundApprovalService backgroundApprovalService;

    @Autowired
    private PctinfoService pctinfoService;

    @Autowired
    private PersonAddService personAddService;
    private static BackGroupCensorService backGroupCensorService;

    @Autowired
    private SyncDepartService syncDepartService;

    @Autowired
    private MinisterialUtil ministerialUtil;

    @Autowired
    private MinisterialLogService ministerialLogService;

    /***
     * 部级接口
     *
     * @return
     */
    @RequestMapping("sendPer")
    public @ResponseBody
    AjaxResult sendPer(String idNum) throws Exception {
        AjaxResult result = new AjaxResult();
            SecurityPerson person = securityPersonService.findByIdCard(idNum);
        try {
            syncDepartService.buildWebServiceEntity(person);
        } catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        result.setSuccessful(true);
        return result;
    }

    /***
     * 部级接口
     *
     * @return
     */
    @RequestMapping("bjPerson")
    public @ResponseBody
    AjaxResult bjPerson() {
        AjaxResult result = new AjaxResult();
        try {
            syncDepartService.person();
            result.setSuccessful(true);
        } catch (Exception e) {
            logger.error(e.getMessage(), e);
            throw e;
        }
        return result;
    }

    /***
     * 部级接口
     *
     * @return
     */
    @RequestMapping("mPerson")
    public @ResponseBody
    AjaxResult mPerson(String idnum) {
        AjaxResult result = new AjaxResult();
        try {
            MinisterialDataType dataType = MinisterialDataType.BAYXXB;
            Map<String,String> paramMap = new HashMap<>();
            paramMap.put("columnName","id_number");
            paramMap.put("columnValue",idnum);
            List<Map> list = ministerialLogService.getBusinessDatasByParam(dataType, paramMap);
            List dataList = JSONArray.parseArray(JSONArray.toJSONString(list),dataType.getDataClazz());

            String serialNo = serialNo = ministerialUtil.send(dataType,dataList);
            MinisterialLog log = new MinisterialLog();
            log.setBusinessType(dataType.getCode());
            log.setSerialNo(serialNo);
            log.setState("1");
            log.setActive(true);
            log.setCreateTime(new Date());
            log.setUpdateTime(new Date());
            ministerialLogService.saveByType(log,dataList);
            result.setSuccessful(true);
            result.setMsg("11");
        } catch (Exception e) {
            logger.error(e.getMessage(), e);
            throw e;
        }
        return result;
    }


    /***
     * 部级接口
     *
     * @return
     */
    @RequestMapping("bjImg")
    public @ResponseBody
    AjaxResult bjImg() {
        AjaxResult result = new AjaxResult();
        try {
            syncDepartService.img();
            result.setSuccessful(true);
        } catch (Exception e) {
            logger.error(e.getMessage(), e);
            throw e;
        }
        return result;
    }


    /***
     * 部级接口
     *
     * @return
     */
    @RequestMapping("bjRest")
    public @ResponseBody
    AjaxResult bjRest() {
        AjaxResult result = new AjaxResult();
        try {
            syncDepartService.bjRest();
            result.setSuccessful(true);
        } catch (Exception e) {
            logger.error(e.getMessage(), e);
            throw e;
        }
        return result;
    }



    /***
     * 先获取背景筛查实现类对
     */
    private void getBackGroupCensorService(){
        if(backGroupCensorService == null){
            backGroupCensorService = BackGroupCensorServiceBeanFactory.getBackGroupCensorServiceBean();
        }
    }
    /**
     * 保安员证审批流程修复页面
     * @return
     */
    @RequestMapping("init")
    public ModelAndView personcertificateInit() {
        ModelAndView view = new ModelAndView("/manage/personcertificate/manageList");
        return view;
    }

    /**
     * 批量操作页面
     * @param type
     * @return
     */
    @RequestMapping("batch/{type}")
    public ModelAndView batchInit(@PathVariable String type) {
        ModelAndView view = new ModelAndView("/manage/personcertificate/batch");
        view.addObject("type",type);
        return view;
    }

    /**
     * 列表分页查询
     * @param params
     * @param req
     * @return
     */
    @RequestMapping("searchList")
    @ResponseBody
    public TableResult searchList(@RequestParam Map<Object, Object> params, HttpServletRequest req) {
        //查询初始化
        Map<Object, Object> p = CTLUtil.init(req, params);
        Config nativeConfig = configUtils.getConfigByKey(Constants.CURRENT_NATIVE);
        p.put("areaCode", nativeConfig.getValue());

        PersoncertificateSearchDto searchDto = new PersoncertificateSearchDto();
        searchDto.setName(params.get("name") ==null?"": params.get("name").toString());
        searchDto.setCardnumber(params.get("cardnumber") ==null?"": params.get("cardnumber").toString());
        searchDto.setApprovalstate(params.get("approvalstate") ==null?"": params.get("approvalstate").toString());
        searchDto.setNumPerPage(Integer.parseInt(params.get("limit").toString()));
        searchDto.setPaging(true);
        searchDto.setPageNum(Integer.parseInt(params.get("offset").toString())/Integer.parseInt(params.get("limit").toString()));
        PageResult page = personcertificateService.queryTable(searchDto);
        TableResult result = new TableResult();
        result.setTotal(page.getTotal());
        result.setRows(page.getRows());
        return result;
    }

    /**
     * 批量操作
     * @param personIds
     * @param type
     * @return
     */
    @RequestMapping("batchOperation")
    @ResponseBody
    public JSONObject batchOperation(String personIds,String type) {
        try {
            Config config = configUtils.getConfigByKey("approvalflag");
            if (config != null && config.getValue().equals("1")) {
                config.setValue("0");
                configUtils.updateForKey(config);
                try {
                    if (StringUtil.isNotEmpty(personIds)) {
                        personIds = personIds.replaceAll("\n", ",");
                        String[] personIdArr = personIds.split(",");
                        if (personIdArr != null && personIdArr.length > 0) {
                            ThreadPoolManager threadPoolManager = ThreadPoolManager.newInstance();
                            for (String personId : personIdArr) {
                                if (StringUtil.isNotEmpty(personId)) {
                                    try {
                                        threadPoolManager.addExecuteTask(new PersoncertificateRunnable(activityRepairService, Long.parseLong(personId), type));
                                    } catch (Exception e) {
                                        logger.error(e.getMessage(), e);
                                    }
                                }
                            }
                        }
                    }
                } catch (Exception e) {
                    logger.error(e.getMessage(), e);
                    return ManageResultUtil.returnFailedJson("操作失败","personcertificateList", "closeCurrent", "");
                }
            } else {
                return ManageResultUtil.returnFailedJson("请勿重复操作","personcertificateList", "closeCurrent", "");
            }
            return ManageResultUtil.returnSuccessJson("后台运行中","personcertificateList","", "");
        } catch (Exception e) {
            logger.error(e.getMessage(), e);
            return ManageResultUtil.returnFailedJson("操作失败","personcertificateList", "closeCurrent", "");
        }
    }
    @Autowired
    private ClientUtil clientUtil;
    /***
     * 根据身份证获取指纹
     * @param cardnumber
     * @return
     */
    @RequestMapping("getZWClient")
    @ResponseBody
    public AjaxResult getZWClient(String cardnumber) {
        Pctinfo result = null;
        AjaxResult ajaxResult = new AjaxResult();
        Personcertificate  personcertificate =  new Personcertificate();
        personcertificate.setPoliceCode("450000030000");
        personcertificate.setPoliceName("广西公安厅治安警察总队");
        personcertificate.setCardnumber(cardnumber);
        String xml = "";//clientUtil.queryZWForIdNumberXML(personcertificate);
        ajaxResult.setData(xml);
        return ajaxResult;
    }


    /***
     * 北京
     * @param cardnumber
     * @return
     */
    @RequestMapping("bjscrk")
    @ResponseBody
    public AjaxResult bjscrk(String cardnumber) {
        AjaxResult result = new AjaxResult();
        //getBackGroupCensorService();
        //BackgroundApprovalDto dto = new BackgroundApprovalDto();
        //dto.setIdNumber(cardnumber);
        //result.setSuccessful(true);
        //result.setData(backGroupCensorService.censor(dto));
        return result;
    }

    private String getPopulationInfoFromBase(String cardnumber){
        String url = "http://10.13.174.223:7080/person/baseInfo/"+cardnumber;
        HashMap<String, Object> paramMap = new HashMap<>();
        paramMap.put("policesfzh", Constants.POLICESFZH);
        paramMap.put("policeorg", Constants.POLICEORG);
        paramMap.put("policemanid", Constants.POLICEMANID);
        paramMap.put("clientId", Constants.CLIENTID);
        paramMap.put("policename", Constants.POLICENAME);
        String resultjson = HttpUtil.get(url, paramMap);
        System.out.println("身份证号："+cardnumber+"，人口库："+resultjson);
        return resultjson;
    }

    public static void main(String[] args) {


    }

    /***
     * 北京
     * @return
     */
    @RequestMapping("sxPerson")
    @ResponseBody
    public AjaxResult sxPerson() {
        AjaxResult result = new AjaxResult();
        RbspService service = new RbspService(Constants.CZ_REQUESTID, Constants.CZ_SERVICEID);
        //用户信息
        service.setUserCardId("asdfasd");
        service.setUserDept("0100");
        service.setUserName("ptjian");
        RbspCall call = service.createCall();
        call.setUrl("http://92.1.31.7:8080/node");
        call.setMethod(RbspConsts.METHOD_QUERY);
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("DataObjectCode", "M001");
        params.put("InfoCodeMode", "1");
        //按身份证号查
        params.put("Condition", "XM = '安婷' and  SFZH like '%1988%'");
        //返回字段：照片
        params.put("RequiredItems", new String[]{"XM"});
        String result1 = call.invoke(params);
        System.out.println("人口库返回信息："+result1);
        result.setData("成功");
        result.setSuccessful(true);
        return result;
    }

    /***
     * 北京
     * @param cardnumber
     * @return
     */
    @RequestMapping("personImg")
    @ResponseBody
    public AjaxResult personImg(String cardnumber) {
        AjaxResult result = new AjaxResult();
        if(StringUtil.isNotEmpty(cardnumber)){
            getBackGroupCensorService();
            PersonBaseInfo populationInfo = backGroupCensorService.getPopulationInfo(cardnumber,true);
            if(populationInfo != null){
                result.setData(populationInfo);
                result.setMsg("成功");
                result.setSuccessful(true);
            }else {
                result.setMsg("失败");
                result.setSuccessful(false);
            }
        }else{
            result.setMsg("请填写身份证号");
            result.setSuccessful(false);
        }
        return result;
    }


    /***
     * 北京
     * @param cardnumber
     * @return
     */
    @RequestMapping("bjsc")
    @ResponseBody
    public AjaxResult bjsc(String cardnumber) {
        AjaxResult result = new AjaxResult();
         syncDepartService.bjsc();
        return result;
    }

    /***
     * 根据身份证获取指纹
     * @param cardnumber
     * @return
     */
    @RequestMapping("getZW")
    @ResponseBody
    public AjaxResult getZW(String cardnumber) {
        AjaxResult ajaxResult = new AjaxResult();
        Personcertificate  personcertificate =  new Personcertificate();
        personcertificate.setPoliceCode("450000030000");
        personcertificate.setPoliceName("广西公安厅治安警察总队");
        personcertificate.setCardnumber(cardnumber);
        String pctinfo = "";//clientUtil.queryZWForIdNumberALL(personcertificate);
        ajaxResult.setData(pctinfo);
        return ajaxResult;
    }
    /**
     * 背景筛查
     * @param personId
     * @return
     */
    @RequestMapping("bgScreen/{personId}")
    @ResponseBody
    public JSONObject bgScreen(@PathVariable Long personId) {
        try {
            Personcertificate personcertificate = personcertificateService.findById(personId);
            if (StringUtil.isEmpty(personcertificate.getCensorStatus()) || personcertificate.getCensorStatus().equals(Constants.CENSORSTATUS_WAIT)) {
                //背景筛查开始
                BackgroundApprovalDto backgroundApprovalDto = new BackgroundApprovalDto();
                backgroundApprovalDto.setBusinessid(personcertificate.getId());
                backgroundApprovalDto.setBusinesstype(Constants.BAYZ);
                backgroundApprovalDto.setIdNumber(personcertificate.getCardnumber());
                backgroundApprovalDto.setRealName(personcertificate.getName());
                //对接八大库查询
                backgroundApprovalService.approval(backgroundApprovalDto);
                //查询结果
                List<BackgroundApproval> list = backgroundApprovalService.query(backgroundApprovalDto);
                Boolean pass = true;
                Boolean startActiviti = false;
                for (BackgroundApproval backgroundApproval : list) {
                    if (Constants.APPROVALSTATE_BTG.equals(backgroundApproval.getApprovalstate())) {
                        pass = false;
                        break;
                    }
                }
                //判断背景筛查是否通过
                if (pass) {
                    //背景筛查通过
                    personcertificate.setCensorStatus(Constants.CENSORSTATUS_PASS);
                    //是否显示指纹录入环节
                    Config isShowFingerprintConfig = configUtils.getConfigByKey(Constants.IS_SHOW_FINGERPRINT);
                    if (isShowFingerprintConfig == null || (StringUtil.isNotEmpty(isShowFingerprintConfig.getValue())
                            && Constants.IS_SHOW_FINGERPRINT_YES.equals(isShowFingerprintConfig.getValue()))) {
                        //获取指纹
                        Pctinfo pctinfo = pctinfoService.findByIdnumber(personcertificate.getCardnumber());

                        if (pctinfo != null) {
                            //获取到指纹 开启 activiti流程
                            personcertificate.setFingerprint(pctinfo.getBarcode());
                            personcertificate.setFingercardState(Constants.FINGERCARD_STATE_JL);
                            startActiviti = true;
                        }
                    } else {
                        startActiviti = true;
                    }

                } else {
                    //背景筛查不通过 开启 activiti流程
                    personcertificate.setCensorStatus(Constants.CENSORSTATUS_UNPASS);
                    startActiviti = true;
                }
                //更新背景筛查状态
                personcertificate.setUpdateTime(new Date());
                personcertificateService.updateCensorStatus(personcertificate);

                if (startActiviti) {
                    Config needActiviti = configUtils.getConfigByKey(Constants.IS_NEED_ACTIVITY);
                    if(needActiviti == null || (StringUtil.isNotEmpty(needActiviti.getValue()) && Constants.IS_NEED_ACTIVITY_YES.equals(needActiviti.getValue()))){
                        activityRepairService.restartProcess(personId);
                    }
                }
                return ManageResultUtil.returnSuccessJson("操作成功","personcertificateList","refreshCurrent", "");
            } else {
                return ManageResultUtil.returnFailedJson("该笔已做过背景筛查","personcertificateList", "closeCurrent", "");
            }

        } catch (Exception e) {
            logger.error(e.getMessage(), e);
            return ManageResultUtil.returnFailedJson("操作失败","personcertificateList", "closeCurrent", "");
        }
    }

    /**
     * 背景筛查
     * @param personId
     * @return
     */
    @RequestMapping("censorStatus/{personId}")
    @ResponseBody
    public JSONObject censorStatus(@PathVariable Long personId) {
        try {
            Personcertificate personcertificate = personcertificateService.findById(personId);
            //背景筛查开始
            BackgroundApprovalDto backgroundApprovalDto = new BackgroundApprovalDto();
            backgroundApprovalDto.setBusinessid(personcertificate.getId());
            backgroundApprovalDto.setBusinesstype(Constants.BAYZ);
            backgroundApprovalDto.setIdNumber(personcertificate.getCardnumber());
            backgroundApprovalDto.setRealName(personcertificate.getName());
            //对接八大库查询
            backgroundApprovalService.approval(backgroundApprovalDto);
            //查询结果
            List<BackgroundApproval> list = backgroundApprovalService.query(backgroundApprovalDto);
            Boolean pass = true;
            for (BackgroundApproval backgroundApproval : list) {
                if (Constants.APPROVALSTATE_BTG.equals(backgroundApproval.getApprovalstate())) {
                    pass = false;
                    break;
                }
            }
            String msg = "背景筛查不通过";
            if(pass){
                msg = "背景筛查通过";
            }
            return ManageResultUtil.returnSuccessJson(msg,"personcertificateList","refreshCurrent", "");

        } catch (Exception e) {
            logger.error(e.getMessage(), e);
            return ManageResultUtil.returnFailedJson("操作失败","personcertificateList", "closeCurrent", "");
        }
    }

    /**
     * 北京核查库变更,要求有以下四个参数和四个请求头
     * @param beQueriedPeopleIdCardNumber 被查询人员的身份证号
     * @return
     */
    @RequestMapping("checkPersonBaseInfo")
    @ResponseBody
    private String checkPersonBaseInfo(String beQueriedPeopleIdCardNumber) throws IOException {

        Assert.notBlank(beQueriedPeopleIdCardNumber);
        //请求参数
        Map<String,Object> params = Maps.newHashMapWithExpectedSize(8);
        //mac地址 固定值
        params.put(Constants.BEIJING_CHECK_PERSON_BASE_INFO_PARAM_DEVICE_ID, Constants.BEIJING_DEVICE_ID);
        //查询民警身份证号 固定值
        params.put(Constants.BEIJING_CHECK_PERSON_BASE_INFO_PARAM_POLICE_IDENTITY_NUMBER, Constants.POLICESFZH);
        //查询民警姓名 固定值
        params.put(Constants.BEIJING_CHECK_PERSON_BASE_INFO_PARAM_POLICE_NAME, Constants.POLICENAME);
        //被查询人员的身份证号
        params.put(Constants.BEIJING_CHECK_PERSON_BASE_INFO_PARAM_BE_QUERIED_IDENTITY_NUMBER, beQueriedPeopleIdCardNumber);

        //构建请求
        HttpResponse response = HttpUtil
                .createRequest(Method.GET, Constants.BEIJING_CHECK_PERSON_BASE_INFO_URL)
                .form(params)
                //设置三十秒超时时间
                .timeout(Constants.BEIJING_CHECK_PERSON_BASE_INFO_TIMEOUT)
                //需携带请求头uid 固定值
                .header(Constants.BEIJING_CHECK_PERSON_BASE_INFO_HEADER_UID, Constants.BEIJING_CHECK_PERSON_BASE_INFO_HEADER_UID_VALUE)
                //请求头username 固定值
                .header(Constants.BEIJING_CHECK_PERSON_BASE_INFO_HEADER_USERNAME, Constants.BEIJING_CHECK_PERSON_BASE_INFO_HEADER_USERNAME_VALUE)
                //请求头user pwd 固定值
                .header(Constants.BEIJING_CHECK_PERSON_BASE_INFO_HEADER_USER_PWD, Constants.BEIJING_CHECK_PERSON_BASE_INFO_HEADER_USER_PWD_VALUE)
                .execute();
        return response.body();

    }
    /**
     * 北京核查库 问题人员详细记录
     * @param idnum 被查询人员的身份证号
     * @return
     */
    @RequestMapping("getWffzInfo")
    @ResponseBody
    private String checkPersonWffzInfo(String idnum) throws IOException {
        //请求参数
        Map<String, Object> paramMap = Maps.newHashMapWithExpectedSize(8);
        //mac地址 固定值
        paramMap.put(Constants.BEIJING_CHECK_PERSON_BASE_INFO_PARAM_DEVICE_ID, Constants.BEIJING_DEVICE_ID);
        //查询民警身份证号 固定值
        paramMap.put(Constants.BEIJING_CHECK_PERSON_BASE_INFO_PARAM_POLICE_IDENTITY_NUMBER, Constants.POLICESFZH);
        //查询民警姓名 固定值
        paramMap.put(Constants.BEIJING_CHECK_PERSON_BASE_INFO_PARAM_POLICE_NAME, Constants.POLICENAME);
        //被查询人员的身份证号
        paramMap.put(Constants.BEIJING_CHECK_PERSON_BASE_INFO_PARAM_BE_QUERIED_IDENTITY_NUMBER, idnum);

        //构建请求
        HttpResponse response = HttpUtil
                .createRequest(Method.GET, "http://14.62.1.210:9006/zzxt/jk/helu/checkPersonWffzInfo")
                .form(paramMap)
                //设置三十秒超时时间
                .timeout(Constants.BEIJING_CHECK_PERSON_BASE_INFO_TIMEOUT)
                //需携带请求头uid 固定值
                .header(Constants.BEIJING_CHECK_PERSON_BASE_INFO_HEADER_UID, Constants.BEIJING_CHECK_PERSON_BASE_INFO_HEADER_UID_VALUE)
                //请求头username 固定值
                .header(Constants.BEIJING_CHECK_PERSON_BASE_INFO_HEADER_USERNAME, Constants.BEIJING_CHECK_PERSON_BASE_INFO_HEADER_USERNAME_VALUE)
                //请求头user pwd 固定值
                .header(Constants.BEIJING_CHECK_PERSON_BASE_INFO_HEADER_USER_PWD, Constants.BEIJING_CHECK_PERSON_BASE_INFO_HEADER_USER_PWD_VALUE)
                .execute();
        return response.body();

    }

    /**
     * 补充生成花名册
     * @return
     */
    @RequestMapping("generateSubsidyRoster")
    @ResponseBody
    public JSONObject generateSubsidyRoster() {
        try {
            List<Personcertificate> list = personcertificateService.findUnGenerateSubsidyRoster();
            if(list.size() >0){
                personcertificateService.generateSubsidyRoster(list);
            }
            return ManageResultUtil.returnSuccessJson("操作成功","personcertificateList","refreshCurrent", "");

        } catch (Exception e) {
            logger.error(e.getMessage(), e);
            return ManageResultUtil.returnFailedJson("操作失败","personcertificateList", "closeCurrent", "");
        }
    }

}
