package com.bcxin.ars.rest.app;

import java.util.ArrayList;
import java.util.List;

import com.bcxin.ars.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import com.bcxin.ars.dto.SecurityPersonAppDto;
import com.bcxin.ars.dto.task.WorkStatisticDto;
import com.bcxin.ars.model.SecurityPerson;
import com.bcxin.ars.model.task.AppAd;
import com.bcxin.ars.model.task.AppService;
import com.bcxin.ars.rest.dto.AppAjaxResult;
import com.bcxin.ars.service.SecurityPersonService;
import com.bcxin.ars.service.task.AppAdService;
import com.bcxin.ars.service.task.AppServiceService;
import com.bcxin.ars.util.Constants;
import com.bcxin.ars.util.FirstLetterUtil;

import cn.com.jit.assp.client.util.StringUtils;

@Controller
@RequestMapping("app/service")
/**
 * 企业服务窗列表
 * 
 * @author zhangye
 */
public class AppServiceController {

	private static final Logger logger = LoggerFactory.getLogger(AppServiceController.class);

	@Autowired
	private AppServiceService appServiceService;

	@Autowired
	private SecurityPersonService personService;

	@Autowired
	private AppAdService appAdService;

	/**
	 * 根据保安公司ID、App类型获取APP服务窗服务列表
	 * 
	 * @param companyId
	 *            公司ID
	 * @param appType
	 *            App类型
	 * @return
	 */
	@RequestMapping("v-1-0-9/findappservicelist/{companyId}/{appType}")
	public @ResponseBody AppAjaxResult findAppServiceList(@PathVariable("companyId") Long companyId,
			@PathVariable("appType") String appType) throws Exception {
		AppAjaxResult result = new AppAjaxResult();
		try {
			String errMsg = "";
			// if(companyId == null){
			// errMsg = "公司ID不能为空";
			// result.setSuccessful(false);
			// result.setMsg(errMsg);
			// return result;
			// }
			if (StringUtils.isEmpty(appType)) {
				errMsg = "App类型不能为空";
				result.setSuccessful(false);
				result.setMsg(errMsg);
				return result;
			}
			AppService appService = new AppService();
			appService.setAppType(appType);
			List<AppService> appServiceList = appServiceService.findAppServiceList(appService);
			result.setSuccessful(true);
			result.setEncodeData(appServiceList);
		} catch (Exception e) {
			logger.error(e.getMessage(), e);
			throw e;
		}
		return result;
	}

	/**
	 * 根据保安公司ID获取保安列表
	 * 
	 * @param companyId
	 * @return
	 */
	@RequestMapping("v-1-0-9/findpersonlist/{companyId}")
	public @ResponseBody AppAjaxResult findPersonList(@PathVariable("companyId") Long companyId) throws Exception {
		AppAjaxResult result = new AppAjaxResult();
		try {
			String errMsg = "";
			if (companyId == null) {
				errMsg = "公司ID不能为空";
				result.setSuccessful(false);
				result.setMsg(errMsg);
				return result;
			}
			List<SecurityPersonAppDto> personlist = personService.findAppByCompanyId(companyId);
			List<SecurityPersonAppDto> reslutpersonlist =  new ArrayList<>();
			// 根据真实姓名获取首字母
			if (personlist != null && personlist.size() > 0) {
				for (SecurityPersonAppDto item : personlist) {
					//姓名
					if (!StringUtils.isEmpty(item.getRealname())) {
						item.setInitialname(FirstLetterUtil.getFirstLetter(item.getRealname().substring(0, 1)));
					}else{
						System.out.println("1");
						item.setRealname("无姓名");
						item.setInitialname(FirstLetterUtil.getFirstLetter(item.getRealname().substring(0, 1)));
					}
					//无等级
					if(StringUtils.isEmpty(item.getLevel())){
						System.out.println("2");
						item.setLevel("暂无");
					}
					//无手机
					if(StringUtil.isEmpty(item.getPhone())){
						System.out.println("3");
						item.setPhone("无");
					}
					reslutpersonlist.add(item);


				}
			}
			result.setSuccessful(true);
			result.setEncodeData(reslutpersonlist);
		} catch (Exception e) {
			logger.error(e.getMessage(), e);
			throw e;
		}
		return result;
	}

	/**
	 * 根据保安人员ID获取在职状态
	 * 
	 * @param personId
	 * @return guardstatus:在职(true),离职(false)
	 */
	@RequestMapping("v-1-0-9/findincumbencystatus/{personId}")
	public @ResponseBody AppAjaxResult findIncumbencyStatus(@PathVariable("personId") Long personId) throws Exception {
		AppAjaxResult result = new AppAjaxResult();
		try {
			String errMsg = "";
			if (personId == null) {
				errMsg = "保安人员ID不能为空";
				result.setSuccessful(false);
				result.setMsg(errMsg);
				return result;
			}
			SecurityPerson securityPerson = personService.findById(personId);
			// 根据真实姓名获取首字母
			if (securityPerson == null) {
				errMsg = "查找不到保安员信息";
				result.setSuccessful(false);
				result.setMsg(errMsg);
				return result;
			}
			boolean incumbencyStatus = securityPerson.getIncumbencyStatus().equals(Constants.INCUMBENCYSTATUS_Y) ? true
					: false;
			result.setSuccessful(true);
			result.setEncodeData(incumbencyStatus);
		} catch (Exception e) {
			logger.error(e.getMessage(), e);
			throw e;
		}
		return result;
	}

	/**
	 * 获取广告列表
	 * 
	 * @param appResult
	 * @return
	 */
	@RequestMapping("v-1-0-9/findappadlist/{companyId}/{adType}")
	public @ResponseBody AppAjaxResult findAppAdlist(@PathVariable("companyId") Long companyId,
			@PathVariable("adType") String adType) throws Exception {
		AppAjaxResult result = new AppAjaxResult();
		try {
			AppAd appAd = new AppAd();
			appAd.setCompanyId(companyId);
			appAd.setAdType(adType);
			List<AppAd> appServiceList = appAdService.findAppAdList(appAd);
			result.setSuccessful(true);
			result.setEncodeData(appServiceList);
		} catch (Exception e) {
			logger.error(e.getMessage(), e);
			throw e;
		}
		return result;
	}

	/**
	 * 考勤统计
	 * 
	 * @param personId
	 *            保安人员ID
	 * @param type
	 *            统计类别(1:上周,2:本周,3:上月,4:本月,5:近90日)
	 */
	@RequestMapping("v-1-0-9/findworkcount")
	public @ResponseBody AppAjaxResult findWorkCount(Long personId, String type) throws Exception {
		AppAjaxResult result = new AppAjaxResult();
		try {
			String errMsg = "";
			if (personId == null) {
				errMsg = "保安人员ID不能为空";
				result.setSuccessful(false);
				result.setMsg(errMsg);
				return result;
			}
			if (StringUtils.isEmpty(type)) {
				errMsg = "统计类别不能为空";
				result.setSuccessful(false);
				result.setMsg(errMsg);
				return result;
			}
			// 获取公司ID
			SecurityPerson securityPerson = personService.findById(personId);
			if (securityPerson == null || securityPerson.getRelation() == null
					|| securityPerson.getRelation().getCompany() == null) {
				errMsg = "人员所在公司不存在，考勤统计失败!";
				result.setSuccessful(false);
				result.setMsg(errMsg);
				return result;
			}
			Long companyId = securityPerson.getRelation().getCompany().getId();
			WorkStatisticDto resultData = appServiceService.findWorkCount(companyId, personId, type);
			if (resultData == null) {
				resultData = new WorkStatisticDto();
				resultData.setFinishSumTime(0);
				resultData.setLackCount(0);
				resultData.setLateCount(0);
				resultData.setLeaveEarlyCount(0);
				resultData.setNormalCount(0);
				resultData.setOverPercent(0);
				resultData.setPmantissa(0);
				resultData.setRank(0);
				resultData.setSumTaskFeedBacks(0);
				resultData.setSumTasks(0);
			}
			result.setSuccessful(true);
			result.setData(resultData);
		} catch (Exception e) {
			logger.error(e.getMessage(), e);
			throw e;
		}
		return result;
	}
}
