package com.bcxin.ars.rest.app;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.bcxin.ars.model.User;
import com.bcxin.ars.model.task.AppOtherSystem;
import com.bcxin.ars.rest.dto.AppAjaxResult;
import com.bcxin.ars.rest.util.ArsRestUtil;
import com.bcxin.ars.service.SecurityPersonService;
import com.bcxin.ars.service.task.AppOtherSystemService;
import com.bcxin.ars.xjd.XjdRepay;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import java.util.List;

/**
 * 第三方系统对接
 * 
 * @author zhangye
 * @version 1.0.9
 */
@Controller
@RequestMapping("app/othersystem")
public class AppOtherSystemController {

	Logger logger = LoggerFactory.getLogger(AppOtherSystemController.class);

	@Autowired
	private ArsRestUtil arsUtil;

	@Autowired
	private AppOtherSystemService appOtherSystemService;

	@Autowired
	private SecurityPersonService personService;

	
	/**
	 * 个人中心-我的金融(现金贷)（包含我的健康 即 我的保险）
	 * 
	 * @param appResult
	 * @return
	 */
	@RequestMapping(value = "v-1-0-9/findFinanceAndPolicy")
	public @ResponseBody AppAjaxResult findFinanceAndPolicy(AppAjaxResult appResult) throws Exception {
		AppAjaxResult result = new AppAjaxResult();
		try {
			User user = arsUtil.getCurrentUser();
			if (user != null) {
				//查看现金贷、保险开放权限
				String financeDisplayStatic ="";//现金贷
				AppOtherSystem appOtherSystem_Query = new AppOtherSystem();
				appOtherSystem_Query.setSytemType("1");//现金贷
				List<AppOtherSystem>  financeList =appOtherSystemService.findAppOtherSystemList(appOtherSystem_Query);
				if(financeList == null || financeList.size() < 1 ){
					financeDisplayStatic = "0";
				}else{
					financeDisplayStatic = financeList.get(0).getDisplayStatic();
				}
				 
				List<XjdRepay> resultList = appOtherSystemService.findfinance(user.getId().toString());
				JSONObject resultObj = new JSONObject();
				JSONObject financeObj = new JSONObject();
				JSONObject healthyObj = new JSONObject();
				if(financeDisplayStatic.equals("1")){
					JSONArray financeArr = new JSONArray();
					JSONObject financeDetail = new JSONObject();
					financeDetail.put("icon", "user_easy_loan");
					financeDetail.put("title", "容易借钱，一款走心的借款神器");
					financeDetail.put("desc", "仅需身份证即可极速申请救急钱，让借钱变得");
					financeDetail.put("isAutho", false);
					if (resultList != null && resultList.size() > 0) {
						financeDetail.put("isAutho", true);
						financeDetail.put("loan", resultList.get(0).getApplyAmount() + "元");
						financeDetail.put("expireDate", "");
						financeDetail.put("repayment", "" + "元");
					}
					financeArr.add(financeDetail);
					financeObj.put("icon", "user_my_finance");
					financeObj.put("sectionTitle", "我的金融");
					financeObj.put("list", financeArr);
				}
				JSONArray healthyArr = new JSONArray();
//				if (person.getInsured() && StringUtil.isNotEmpty(person.getBxOrderno())) {
//					Map<String, Object> map = new HashMap<String, Object>();
//					map.put("order_id", person.getBxOrderno());
//					// 保存保险信息
//					String url = ThirdPartyURL.BAILIANBAO + "/api/order/policyDal";
//					String resultStr = messageUtils.doPost2(url, messageUtils.packageMap(map, "ARS"));
//					String product_name = messageUtils.getStringValueByKey(resultStr, "product_name");// 产品名称
//					String planned_end_date = messageUtils.getStringValueByKey(resultStr, "planned_end_date");// 失效日期
//
//					JSONObject healthyDetail = new JSONObject();
//					healthyDetail.put("insurance", (StringUtils.isEmpty(person.getInsuranceAmount())?"0":person.getInsuranceAmount()) + "元");
//					healthyDetail.put("expireDate", planned_end_date);
//					healthyDetail.put("name", product_name);
//
//					healthyArr.add(healthyDetail);
//				}
				healthyObj.put("icon", "user_healthy");
				healthyObj.put("sectionTitle", "我的健康");
				healthyObj.put("list", healthyArr);
				resultObj.put("finance", financeObj);
				resultObj.put("healthy", healthyObj);
				result.setSuccessful(true);
				result.setEncodeData(resultObj);
			} else {
				result.setSuccessful(false);
				result.setMsg("获取用户登陆信息失败");
			}
		} catch (Exception e) {
			logger.error(e.getMessage(), e);
			throw e;
		}
		return result;
	}

}
