package com.bcxin.ars.rest;

import com.bcxin.ars.dto.AjaxResult;
import com.bcxin.ars.model.sb.HandleGuide;
import com.bcxin.ars.service.sb.HandleGuideService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

/**
 * 与saas对接
 * 申报须知信息 (办理指南)
 */
@Controller
@RequestMapping("handleGuide")
public class HandleGuideController {

	Logger logger = LoggerFactory.getLogger(HandleGuideController.class);
	
	@Autowired
	private HandleGuideService handleGuideService;


	/**
	 * 根据业务类型 获取对应的申报须知
	 * @param businessType
	 * @param type
	 * @return
	 * @throws Exception
	 */
	@RequestMapping("findByBusinessType")
	public @ResponseBody AjaxResult findByBusinessType(String businessType,String type) throws Exception {
		AjaxResult result = new AjaxResult();
		try {
			HandleGuide handleGuide = handleGuideService.findByBusinessType(businessType,type);
			if(handleGuide != null){
				result.setSuccessful(true);
				result.setData(handleGuide.getContent());
			}else{
				result.setSuccessful(false);
				result.setMsg("暂无对应的申报须知信息!");
			}
		} catch(Exception e) {
			logger.error(e.getMessage(), e);
			throw e;
		}
		return result;
	}

}
