package com.bcxin.ars.rest;

import com.bcxin.ars.dto.AjaxResult;
import com.bcxin.ars.dto.sb.ConfesscompanySearchDto;
import com.bcxin.ars.model.SecurityTraincompany;
import com.bcxin.ars.model.User;
import com.bcxin.ars.model.sb.Confesscompany;
import com.bcxin.ars.service.SecurityTraincompanyService;
import com.bcxin.ars.service.sb.ConfesscompanyService;
import com.bcxin.ars.service.util.ArsUtil;
import com.bcxin.ars.util.BuildWebServiceEntity;
import com.bcxin.ars.util.CTLUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.Map;

/**
 * Created by 苏 on 2017/5/1.
 */
@Controller
@RequestMapping("confesscompany")
public class ConfesscompanyController {

    private Logger logger = LoggerFactory.getLogger(ConfesscompanyController.class);
    @Autowired
    private ConfesscompanyService confesscompanyService;


    @Autowired
    private ArsUtil arsUtil;


    @RequestMapping("update")
    public @ResponseBody AjaxResult update(Confesscompany confesscompany) throws Exception{
        AjaxResult result = new AjaxResult();
        try {
            User user = arsUtil.getCurrentUser();
            if(user != null) {
                result.setSuccessful(true);
                confesscompanyService.saveOrUpdate(confesscompany);
            } else {
                result.setSuccessful(false);
            }
        } catch(Exception e) {
            logger.error(e.getMessage(), e);
            throw e;
        }
        return result;
    }
}
