package com.bcxin.ars.dao;

import java.util.Date;
import java.util.List;

import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;
import org.springframework.test.context.transaction.TransactionConfiguration;
import org.springframework.transaction.annotation.Transactional;

import com.bcxin.ars.dao.task.TaskTrackDao;
import com.bcxin.ars.model.task.TaskTrack;

@RunWith(SpringJUnit4ClassRunner.class)
@ContextConfiguration(locations = { "classpath:/ars-dao.xml" })
@Transactional
@TransactionConfiguration(transactionManager = "txManager", defaultRollback = true)
public class TaskTrackDaoTest {

	@Autowired
	private TaskTrackDao trackDao;

	@Test
	public void test() {
		TaskTrack track = new TaskTrack();
		track.setLongitude("2342.092312");
		track.setLatitude("2342.341213");
		track.setNativeCode(11l);
		track.setTaskFeedbackId(1l);
		track.setUpdateTime(new Date());
		trackDao.save(track);
		List<TaskTrack> data = trackDao.findByFeedbackId(1l);
		Assert.assertTrue(data.size() > 0);
	}

}
