package com.bcxin.ars.dao;

import java.util.Date;

import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;
import org.springframework.test.context.transaction.TransactionConfiguration;
import org.springframework.transaction.annotation.Transactional;

import com.bcxin.ars.dao.task.TaskScheduleDao;
import com.bcxin.ars.model.SecurityCompanySchedule;
import com.bcxin.ars.model.task.Task;
import com.bcxin.ars.model.task.TaskSchedule;


@RunWith(SpringJUnit4ClassRunner.class)
@ContextConfiguration(locations = { "classpath:/ars-dao.xml" })
@Transactional
@TransactionConfiguration(transactionManager = "txManager", defaultRollback = true)
public class TaskScheduleDaoTest {

	@Autowired
	private TaskScheduleDao taskScheduleDao;

	@Test
	public void testAll() {
		TaskSchedule taskSchedule = new TaskSchedule();
		SecurityCompanySchedule schedule = new SecurityCompanySchedule();
		schedule.setId(3l);
		taskSchedule.setCreateTime(new Date());
		taskSchedule.setTaskId(3l);
		taskSchedule.setSchedule(schedule);
		taskSchedule.setNativeCode(11l);
		Long id = taskScheduleDao.save(taskSchedule);
		Assert.assertTrue(id > 0);
		Task task = new Task();
		task.setId(3l);
		taskScheduleDao.deleteByTask(task);
	}

}
