package com.bcxin.ars.dao;

import java.util.Date;
import java.util.List;

import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;
import org.springframework.test.context.transaction.TransactionConfiguration;
import org.springframework.transaction.annotation.Transactional;

import com.alibaba.fastjson.JSON;
import com.bcxin.ars.dao.task.TaskPersonDao;
import com.bcxin.ars.dto.task.TaskPersonDto;
import com.bcxin.ars.model.SecurityPerson;
import com.bcxin.ars.model.task.TaskPerson;


@RunWith(SpringJUnit4ClassRunner.class)
@ContextConfiguration(locations = { "classpath:/ars-dao.xml" })
@Transactional
@TransactionConfiguration(transactionManager = "txManager", defaultRollback = true)
public class TaskPersonDaoTest {

	@Autowired
	private TaskPersonDao taskPersonDao;

	@Test
	public void testAll() {
		TaskPerson taskPerson = new TaskPerson();
		SecurityPerson person = new SecurityPerson();
		person.setId(7l);
		taskPerson.setCreateTime(new Date());
		taskPerson.setTaskId(1l);
		taskPerson.setPerson(person);
		taskPerson.setNativeCode(11l);
		taskPerson.setInCharge(true);
		Long id = taskPersonDao.save(taskPerson);
		Assert.assertTrue(id > 0);
		List<TaskPerson> data = taskPersonDao.findByTaskId(1l);
		Assert.assertTrue(data.size() > 0);
	}
	
	@Test
	public void testFindTaskPersonsByTaskId(){
		List<TaskPersonDto> taskPersons = taskPersonDao.findTaskPersonsByTaskId(163l);
		System.out.println(JSON.toJSONString(taskPersons));
		Assert.assertTrue(taskPersons.size() > 0);
	}

}
