package com.bcxin.ars.dao;

import java.util.List;

import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;
import org.springframework.test.context.transaction.TransactionConfiguration;
import org.springframework.transaction.annotation.Transactional;

import com.bcxin.ars.model.SecurityScope;

@RunWith(SpringJUnit4ClassRunner.class)
@ContextConfiguration(locations = { "classpath:/ars-dao.xml" })
@Transactional
@TransactionConfiguration(transactionManager = "txManager", defaultRollback = true)
public class SecurityScopeDaoTest {

	@Autowired
	private SecurityScopeDao securityScopeDao;
	
	@Test
	public void testFind() {
		SecurityScope s = securityScopeDao.findById(1l);
		Assert.assertEquals("门卫", s.getName());
		List<SecurityScope> data = securityScopeDao.findAll();
		Assert.assertEquals(9, data.size());
	}
	
}
