package com.bcxin.ars.dao;

import java.util.Date;

import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;
import org.springframework.test.context.transaction.TransactionConfiguration;
import org.springframework.transaction.annotation.Transactional;

import com.bcxin.ars.model.OrderTransaction;

@RunWith(SpringJUnit4ClassRunner.class)
@ContextConfiguration(locations = { "classpath:/ars-dao.xml" })
@Transactional
@TransactionConfiguration(transactionManager = "txManager", defaultRollback = true)
public class OrderTransactionDaoTest {

	@Autowired
	private OrderTransactionDao orderTransactionDao;

	@Test
	public void testSave() {
		OrderTransaction order = new OrderTransaction();
		order.setActive(true);
		order.setCreateTime(new Date());
		order.setUpdateBy("system");
		order.setUpdateTime(new Date());
		order.setMessage("12ewwwwwwwrxg");
		order.setOrderid(12l);
		order.setOrdernum("1213124");
		order.setPaystate("1");
		order.setPaytime(new Date());
		order.setSubmitordertime(new Date());
		
		orderTransactionDao.save(order);
		OrderTransaction dbOrder = orderTransactionDao.findById(order.getId());
		Assert.assertNotNull(dbOrder);
	}
}
