package com.bcxin.ars.dao;

import java.util.Date;

import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;
import org.springframework.test.context.transaction.TransactionConfiguration;
import org.springframework.transaction.annotation.Transactional;

import com.bcxin.ars.model.Order;

@RunWith(SpringJUnit4ClassRunner.class)
@ContextConfiguration(locations = { "classpath:/ars-dao.xml" })
@Transactional
@TransactionConfiguration(transactionManager = "txManager", defaultRollback = true)
public class OrderDaoTest {

	@Autowired
	private OrderDao orderDao;

	@Test
	public void testSave() {
		Order order = new Order();
		order.setActive(true);
		order.setCreateTime(new Date());
		order.setUpdateBy("system");
		order.setUpdateTime(new Date());
		order.setAmount("111");
		order.setCompanyname("1111342423");
		order.setCountnumber(2432);
		order.setEffectiveendtime(new Date());
		order.setEffectivestarttime(new Date());
		order.setGoodsname("1132");
		order.setInvoiceid(123l);
		order.setInvoicename("sdsdfadfas");
		order.setOrdernumber("1256498789");
		order.setOrderstate("1");
		order.setRemarks("dsgadgdsfa");
		order.setSendaddress("13232432");
		order.setSignatory("2");
		order.setTel("12345678");
		order.setTrainorgid(43l);
		order.setTraintype("1");
		order.setUnitprice("1324");
		order.setUserid(123234l);
		
		orderDao.save(order);
		Order dbOrder = orderDao.findById(order.getId());
		Assert.assertNotNull(dbOrder);
	}
}
