package com.bcxin.ars.dao;

import java.util.List;

import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;
import org.springframework.test.context.transaction.TransactionConfiguration;
import org.springframework.transaction.annotation.Transactional;

import com.bcxin.ars.model.Edu;

@RunWith(SpringJUnit4ClassRunner.class)
@ContextConfiguration(locations = { "classpath:/ars-dao.xml" })
@Transactional
@TransactionConfiguration(transactionManager = "txManager", defaultRollback = true)
public class EduDaoTest {

	@Autowired
	private EduDao eduDao;
	
	@Test
	public void testFindAll() {
		List<Edu> eduList = eduDao.findAll();
		Assert.assertTrue(eduList.size() > 0);
	}
	
	@Test
	public void testFindById() {
		Edu edu = eduDao.findById(1l);
		Assert.assertNotNull(edu);
	}
}
