package com.bcxin.ars.dao.supervision;

import com.abcxin.smart.validator.annotation.DataChangeAnnotation;
import com.abcxin.smart.validator.enums.ParamType;
import com.bcxin.ars.model.supervision.PersonComplaint;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * @author yyx
 * @date 2020/06/15
 */
@Service
public class PersonComplaintDaoAop {
    @Autowired
    private PersonComplaintDao personComplaintDao;
    @DataChangeAnnotation(getEntityClazz = PersonComplaint.class,
            getDaoClazz = CompanyComplaintDao.class,
            getParamClazz = Long.class,
            getSearchMethodName = "findByIdWithOutCache")
    public int delete(PersonComplaint personComplaint) {
        return personComplaintDao.delete(personComplaint);
    }
    @DataChangeAnnotation(getEntityClazz = PersonComplaint.class,
            getDaoClazz = PersonComplaintDao.class,
            getParamClazz = Long.class,
            getSearchMethodName = "findByIdWithOutCache")
    public void save(PersonComplaint personComplaint) {
        personComplaintDao.save(personComplaint);
    }

    @DataChangeAnnotation(getEntityClazz = PersonComplaint.class,
            getDaoClazz = PersonComplaintDao.class,
            getParamType = ParamType.ENTITY,
            getParamClazz = List.class,
            getSearchMethodName = "findByBatchIdWithOutCache")
    public void saveBatch(List<PersonComplaint> list) {
        personComplaintDao.saveBatch(list);
    }
}
