package com.bcxin.ars.dao.supervision;

import com.abcxin.smart.validator.annotation.DataChangeAnnotation;
import com.abcxin.smart.validator.enums.ParamType;
import com.bcxin.ars.model.supervision.PersonAward;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * @author yyx
 * @date 2020/06/15
 */
@Service
public class PersonAwardDaoAop {
    @Autowired
    private PersonAwardDao personAwardDao;
    @DataChangeAnnotation(getEntityClazz = PersonAward.class,
            getDaoClazz = CompanyComplaintDao.class,
            getParamClazz = Long.class,
            getSearchMethodName = "findByIdWithOutCache")
    public int delete(PersonAward personAward) {
        return personAwardDao.delete(personAward);
    }
    @DataChangeAnnotation(getEntityClazz = PersonAward.class,
            getDaoClazz = PersonAwardDao.class,
            getParamClazz = Long.class,
            getSearchMethodName = "findByIdWithOutCache")
    public void save(PersonAward personAward) {
        personAwardDao.save(personAward);
    }

    @DataChangeAnnotation(getEntityClazz = PersonAward.class,
            getDaoClazz = PersonAwardDao.class,
            getParamType = ParamType.ENTITY,
            getParamClazz = List.class,
            getSearchMethodName = "findByBatchIdWithOutCache")
    public void saveBatch(List<PersonAward> list) {
        personAwardDao.saveBatch(list);
    }
}
