package com.bcxin.ars.dao.subsidy;

import com.abcxin.smart.validator.annotation.DataChangeAnnotation;
import com.bcxin.ars.dao.sys.ExportConfigColumnDao;
import com.bcxin.ars.dao.sys.ExportConfigDao;
import com.bcxin.ars.model.sys.ExportColumn;
import com.bcxin.ars.model.sys.ExportConfig;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * @author yyx
 * @date 2020/06/15
 */
@Service
public class ExportConfigDaoAop {
    @Autowired
    private ExportConfigDao exportConfigDao;
    @Autowired
    private ExportConfigColumnDao exportConfigColumnDao;

    @DataChangeAnnotation(getEntityClazz = ExportConfig.class,
            getDaoClazz = ExportConfigDao.class,
            getParamClazz = Long.class,
            getSearchMethodName = "findByIdWithOutCache")
    public void save(ExportConfig exportConfig) {
        exportConfigDao.save(exportConfig);
    }
    @DataChangeAnnotation(getEntityClazz = ExportColumn.class,
            getDaoClazz = ExportConfigColumnDao.class,
            getParamClazz = Long.class,
            getSearchMethodName = "findByIdWithOutCache")
    public void saveColumn(ExportColumn exportColumn) {
        exportConfigColumnDao.save(exportColumn);
    }
}
