package com.bcxin.ars.dao.sb;

import com.abcxin.smart.validator.annotation.DataChangeAnnotation;
import com.abcxin.smart.validator.enums.ParamType;
import com.bcxin.ars.model.sb.TrainChange;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * @author linqinglin
 * @date 2020/06/18 0018 11:24
 */
@Service
public class TrainChangeDaoAop {

    @Autowired
    private TrainChangeDao trainChangeDao;

    @DataChangeAnnotation(getEntityClazz = TrainChange.class,
            getDaoClazz = TrainChangeDao.class,
            getParamClazz = Long.class,
            getSearchMethodName = "findByIdWithOutCache")
    public void delete(TrainChange trainChange) {
        trainChangeDao.delete(trainChange);
    }

    @DataChangeAnnotation(getEntityClazz = TrainChange.class,
            getDaoClazz = TrainChangeDao.class,
            getParamClazz = Long.class,
            getSearchMethodName = "findByIdWithOutCache")
    public void update(TrainChange trainChange) {
        trainChangeDao.update(trainChange);
    }

    @DataChangeAnnotation(getEntityClazz = TrainChange.class,
            getDaoClazz = TrainChangeDao.class,
            getParamType = ParamType.ENTITY,
            getParamClazz = List.class,
            getSearchMethodName = "findByBatchIdWithOutCache")
    public void updateBatch(List<TrainChange> list){
        trainChangeDao.updateBatch(list);
    }
}
