package com.bcxin.ars.dao.sb;

import com.abcxin.smart.validator.annotation.DataChangeAnnotation;
import com.abcxin.smart.validator.enums.ParamType;
import com.bcxin.ars.model.sb.Subsidiary;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * @author linqinglin
 * @date 2020/05/11 0011 17:34
 */
@Service
public class SubsidiaryDaoAop {

    @Autowired
    private SubsidiaryDao subsidiaryDao;

    @DataChangeAnnotation(getEntityClazz = Subsidiary.class,
            getDaoClazz = SubsidiaryDao.class,
            getParamClazz = Long.class,
            getSearchMethodName = "findByIdWithOutCache")
    public void update(Subsidiary subsidiary) {
        subsidiaryDao.update(subsidiary);
    }

    @DataChangeAnnotation(getEntityClazz = Subsidiary.class,
            getDaoClazz = SubsidiaryDao.class,
            getParamType = ParamType.ENTITY,
            getParamClazz = List.class,
            getSearchMethodName = "findByBatchIdWithOutCache")
    public void updateBatch(List<Subsidiary> list){
        subsidiaryDao.updateBatch(list);
    }
}
