package com.bcxin.ars.dao.sb;

import com.abcxin.smart.validator.annotation.DataChangeAnnotation;
import com.abcxin.smart.validator.enums.ParamType;
import com.bcxin.ars.model.sb.GradeSubsidyBatchRoster;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * @author linqinglin
 * @date 2020/06/03 0003 9:48
 */
@Service
public class GradeSubsidyBatchRosterDaoAop {


    @Autowired
    private GradeSubsidyBatchRosterDao gradeSubsidyBatchRosterDao;

    @DataChangeAnnotation(getEntityClazz = GradeSubsidyBatchRoster.class,
            getDaoClazz = GradeSubsidyBatchRosterDao.class,
            getParamClazz = Long.class,
            getSearchMethodName = "findByIdWithOutCache")
    public int delete(GradeSubsidyBatchRoster trainSubsidyConfig) {
        return gradeSubsidyBatchRosterDao.delete(trainSubsidyConfig);
    }

    @DataChangeAnnotation(getEntityClazz = GradeSubsidyBatchRoster.class,
            getDaoClazz = GradeSubsidyBatchRosterDao.class,
            getParamClazz = Long.class,
            getSearchMethodName = "findByIdWithOutCache")
    public int save(GradeSubsidyBatchRoster trainSubsidyConfig) {
        return gradeSubsidyBatchRosterDao.save(trainSubsidyConfig);
    }

    @DataChangeAnnotation(getEntityClazz = GradeSubsidyBatchRoster.class,
            getDaoClazz = GradeSubsidyBatchRosterDao.class,
            getParamType = ParamType.ENTITY,
            getParamClazz = List.class,
            getSearchMethodName = "findByBatchIdWithOutCache")
    public void saveBatch(List<GradeSubsidyBatchRoster> list) {
        gradeSubsidyBatchRosterDao.saveBatch(list);
    }
}
