package com.bcxin.ars.dao.sb;

import com.abcxin.smart.validator.annotation.DataChangeAnnotation;
import com.abcxin.smart.validator.enums.ParamType;
import com.bcxin.ars.model.sb.GradeSubsidyBatch;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * @author linqinglin
 * @date 2020/06/03 0003 9:48
 */
@Service
public class GradeSubsidyBatchDaoAop {


    @Autowired
    private GradeSubsidyBatchDao gradeSubsidyBatchDao;

    @DataChangeAnnotation(getEntityClazz = GradeSubsidyBatch.class,
            getDaoClazz = GradeSubsidyBatchDao.class,
            getParamClazz = Long.class,
            getSearchMethodName = "findByIdWithOutCache")
    public int delete(GradeSubsidyBatch trainSubsidyConfig) {
        return gradeSubsidyBatchDao.delete(trainSubsidyConfig);
    }

    @DataChangeAnnotation(getEntityClazz = GradeSubsidyBatch.class,
            getDaoClazz = GradeSubsidyBatchDao.class,
            getParamClazz = Long.class,
            getSearchMethodName = "findByIdWithOutCache")
    public void save(GradeSubsidyBatch trainSubsidyConfig) {
        gradeSubsidyBatchDao.save(trainSubsidyConfig);
    }

    @DataChangeAnnotation(getEntityClazz = GradeSubsidyBatch.class,
            getDaoClazz = GradeSubsidyBatchDao.class,
            getParamClazz = Long.class,
            getSearchMethodName = "findByIdWithOutCache")
    public void updateSelective(GradeSubsidyBatch trainSubsidyConfig) {
        gradeSubsidyBatchDao.updateSelective(trainSubsidyConfig);
    }
    @DataChangeAnnotation(getEntityClazz = GradeSubsidyBatch.class,
            getDaoClazz = GradeSubsidyBatchDao.class,
            getParamType = ParamType.ENTITY,
            getParamClazz = List.class,
            getSearchMethodName = "findByBatchIdWithOutCache")
    public void saveBatch(List<GradeSubsidyBatch> list) {
        gradeSubsidyBatchDao.saveBatch(list);
    }
}
