package com.bcxin.ars.dao.sb;

import com.abcxin.smart.validator.annotation.DataChangeAnnotation;
import com.abcxin.smart.validator.enums.ParamType;
import com.bcxin.ars.model.sb.Confesscompany;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * @author linqinglin
 * @date 2020/05/11 0011 17:34
 */
@Service
public class ConfesscompanyDaoAop {

    @Autowired
    private ConfesscompanyDao confesscompanyDao;

    @DataChangeAnnotation(getEntityClazz = Confesscompany.class,
            getDaoClazz = ConfesscompanyDao.class,
            getParamClazz = Long.class,
            getSearchMethodName = "findByIdWithOutCache")
    public void delete(Confesscompany confesscompany) {
        confesscompanyDao.delete(confesscompany);
    }

    @DataChangeAnnotation(getEntityClazz = Confesscompany.class,
            getDaoClazz = ConfesscompanyDao.class,
            getParamClazz = Long.class,
            getSearchMethodName = "findByIdWithOutCache")
    public void update(Confesscompany confesscompany) {
        confesscompanyDao.update(confesscompany);
    }

    @DataChangeAnnotation(getEntityClazz = Confesscompany.class,
            getDaoClazz = ConfesscompanyDao.class,
            getParamType = ParamType.ENTITY,
            getParamClazz = List.class,
            getSearchMethodName = "findByBatchIdWithOutCache")
    public void updateBatch(List<Confesscompany> list){
        confesscompanyDao.updateBatch(list);
    }
}
