package com.bcxin.ars.dao;

import com.abcxin.smart.validator.annotation.DataChangeAnnotation;
import com.abcxin.smart.validator.enums.ParamType;
import com.bcxin.ars.dto.SecurityPersonDTO;
import com.bcxin.ars.model.SecurityPerson;
import com.bcxin.ars.model.appeal.Appeal;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Date;
import java.util.List;

/**
 * @author linqinglin
 * @date 2020/06/09 0009 9:21
 */
@Service
public class SecurityPersonDaoAop {


    @Autowired
    private SecurityPersonDao securityPersonDao;

    @DataChangeAnnotation(getEntityClazz = SecurityPerson.class,
            getDaoClazz = SecurityPersonDao.class,
            getParamClazz = Long.class,
            getSearchMethodName = "findByIdWithOutCache")
    public void update(SecurityPerson securityPerson){
        securityPersonDao.update(securityPerson);
    }

    @DataChangeAnnotation(getEntityClazz = SecurityPerson.class,
            getDaoClazz = SecurityPersonDao.class,
            getParamClazz = Long.class,
            getSearchMethodName = "findByIdWithOutCache")
    public void updateSelective(SecurityPerson securityPerson){
        securityPersonDao.updateSelective(securityPerson);
    }

    @DataChangeAnnotation(getEntityClazz = SecurityPerson.class,
            getDaoClazz = SecurityPersonDao.class,
            getParamType = ParamType.ENTITY,
            getParamClazz = List.class,
            getSearchMethodName = "findByBatchIdWithOutCache")
    public void updateBatch(List<SecurityPerson> list) {
        securityPersonDao.updateBatch(list);
    }

    @DataChangeAnnotation(getEntityClazz = SecurityPerson.class,
            getDaoClazz = SecurityPersonDao.class,
            getParamType = ParamType.ENTITY,
            getParamClazz = List.class,
            getSearchMethodName = "findByBatchIdWithOutCache")
    public void batchUpdateCertificate(List<SecurityPerson> list) {
        securityPersonDao.batchUpdateCertificate(list);
    }

    @DataChangeAnnotation(getEntityClazz = SecurityPerson.class,
            getDaoClazz = SecurityPersonDao.class,
            getParamType = ParamType.ENTITY,
            getParamClazz = List.class,
            getSearchMethodName = "findByBatchIdWithOutCache")
    public void updateBXBatch(List<SecurityPerson> list) {
        securityPersonDao.updateBXBatch(list);
    }

    @DataChangeAnnotation(getEntityClazz = SecurityPerson.class,
            getDaoClazz = SecurityPersonDao.class,
            getParamType = ParamType.ENTITY,
            getParamClazz = List.class,
            getSearchMethodName = "findByBatchIdWithOutCache")
    public void updateCensorStatusList(List<SecurityPerson> list) {
        securityPersonDao.updateCensorStatusList(list);
    }

    @DataChangeAnnotation(getEntityClazz = SecurityPersonDTO.class,
            getDaoClazz = SecurityPersonDao.class,
            getParamType = ParamType.ENTITY,
            getParamClazz = List.class,
            getSearchMethodName = "findByBatchIdWithOutCache")
    public void updatePersonidentityAuthStateBatch(List<SecurityPersonDTO> list) {
        securityPersonDao.updatePersonidentityAuthStateBatch(list);
    }

    @DataChangeAnnotation(getEntityClazz = SecurityPersonDTO.class,
            getDaoClazz = SecurityPersonDao.class,
            getParamType = ParamType.ENTITY,
            getParamClazz = List.class,
            getSearchMethodName = "findByBatchIdWithOutCache")
    public void updatePersonidentityAuthStateBatchForPhoto(List<SecurityPersonDTO> list) {
        securityPersonDao.updatePersonidentityAuthStateBatchForPhoto(list);
    }

    @DataChangeAnnotation(getEntityClazz = SecurityPerson.class,
            getDaoClazz = SecurityPersonDao.class,
            getParamType = ParamType.ENTITY,
            getParamClazz = List.class,
            getSearchMethodName = "findByAppealsWithOutCache")
    public void updateBatchAuthState(List<Appeal> list) {
        securityPersonDao.updateBatchAuthState(list);
    }

    @DataChangeAnnotation(getEntityClazz = SecurityPerson.class,
            getDaoClazz = SecurityPersonDao.class,
            getParamType = ParamType.ENTITY,
            getParamClazz = Long[].class,
            getSearchMethodName = "findBatchWithOutCache")
    public void updateDeletePerson(Long[] idArray, Date updateTime, String updateBy, Date leaveDate){
        securityPersonDao.updateDeletePerson(idArray,updateTime,updateBy,leaveDate);
    }

    @DataChangeAnnotation(getEntityClazz = SecurityPerson.class,
            getDaoClazz = SecurityPersonDao.class,
            getParamType = ParamType.ENTITY,
            getParamClazz = Long[].class,
            getSearchMethodName = "findBatchWithOutCache")
    public void updatePersonInsuredState(Long[] idArray, String status){
        securityPersonDao.updatePersonInsuredState(idArray,status);
    }

    @DataChangeAnnotation(getEntityClazz = SecurityPerson.class,
            getDaoClazz = SecurityPersonDao.class,
            getParamClazz = Long.class,
            getSearchMethodName = "findByIdWithOutCache")
    public void delIdPhoto(SecurityPerson person) {
        securityPersonDao.delIdPhoto(person);
    }
}
