package com.bcxin.ars.dao.task;

import java.util.List;

import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.model.task.TaskTrack;

/**
 * 任务轨迹数据类
 * @author Ethan
 */
public interface TaskTrackDao {

	/**
	 * 新增任务轨迹
	 * @param track
	 * @return
	 */
	Long save(TaskTrack track);
	
	/**
	 * 根据任务获取轨迹列表
	 * @param feedbackId
	 * @return
	 */
	List<TaskTrack> findByFeedbackId(Long feedbackId);
	
	/**
	 * 根据任务和人员获取轨迹列表
	 * @param feedbackId
	 * @param personId
	 * @return
	 */
	List<TaskTrack> findByFeedbackIdPersonId(Long feedbackId,Long personId);


	List<TaskTrack> searchForDataSynchronization(DataSynchronizationSearchDto dto);

	/**
	 * 根据id批量查询
	 * @param list
	 * @return
	 */
	List<TaskTrack> findByBatchId(List<TaskTrack> list);

	/**
	 * 批量保存
	 * @param list
	 */
	void saveBatch(List<TaskTrack> list);
}
