package com.bcxin.ars.dao.sys;
import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.dto.sys.SysDictDto;
import com.bcxin.ars.model.sys.Sysdict;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;

import java.util.List;

/**
 * @author  wjb
 * @date 2018年8月16日17:49:21
 * @desc 编码表 sys_dict 所对应的DAO
 */
public interface SysdictDAO {
    /***
     * 查询所有编码
     * @return
     */
    List findAll();

    /**
     * 根据类型查询
     * @param codeType
     * @return
     */
    List findByCodeType(String codeType);

    /**
     * 查询所有的码表
     * @param sysDictDto
     * @param page
     */
    List<Sysdict> search(SysDictDto sysDictDto, AjaxPageResponse page);

    /**
     * 根据id查询
     * @param id
     * @return
     */
    Sysdict findById(Long id);

    /***
     * 保存
     * @param sysdict
     */
    void save(Sysdict sysdict);

    /**
     * 外导内查询
     * @param searchDto
     * @return
     */
    List<Sysdict> searchForDataSynchronization(DataSynchronizationSearchDto searchDto);

    /**
     * 内导外查询
     * @param startDate
     * @return
     */
    List<Sysdict> findDSOutList(String startDate);

    /**
     * 根据ID批量查询
     * @param list
     * @return
     */
    List<Sysdict> findByBatchId(List<Sysdict> list);

    /**
     * 保存
     * @param list
     */
    void saveBatch(List<Sysdict> list);
}