package com.bcxin.ars.dao.sys;

import com.bcxin.ars.model.sys.ApprovalLog;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Map;

public interface ApprovalLogDao {

    void delete(ApprovalLog approvalLog);

    Long save(ApprovalLog approvalLog);
    /**
     *
     * @Decription:批量保存
     * @author：zhongjianhui
     * @method  saveBatch
     * @date：2018/8/14 16:11
     * @params： * @param approvalLog
     * @return java.lang.Long
     */
    Long saveBatch(@Param("approvalLogList") List<ApprovalLog> approvalLogList);
    /**
     *
     * @Decription:批量查询ID是否有在列表中
     * @author：zhongjianhui
     * @method  findByBatchId
     * @date：2018年8月15日 09:34:50
     * @params： * @param approvalLog
     * @return java.lang.Long
     */
    List<ApprovalLog> findByBatchId(@Param("approvalLogList") List<ApprovalLog> approvalLogList);

    ApprovalLog findById(Long id);

    void update(ApprovalLog approvalLog);

    List<ApprovalLog> findByProcessInstanceId(String processInstanceId);

    List<ApprovalLog> findByProcessInstanceId_new(String processInstanceId);

    void updateProcessInstanceId(String processInstanceId, String inProcessInstanceId);

    List<ApprovalLog> findByApprovalId_new(String approvalId);

    List<ApprovalLog> findByApprovalId_old(String approvalId);

    List<ApprovalLog> findByProcessInstanceId_new_old(String approvalId);

    List<ApprovalLog> findByApprovalId_new_old(String approvalId);
    /**
     *
     * @Decription: 通过进程id查询打印信息
     * @author：zhongjianhui
     * @method  findPrintfMessageByApprovalId
     * @date：2018/8/9 10:49
     * @params： * @param processInstanceId
     * @return java.util.Map
     */
    Map findPrintfMessageByApprovalId(Map map);

    /**
     * 内导外数据
     * @param startDate 开始时间
     * @return
     */
    List<ApprovalLog> findApprovalLogByTime(String startDate);

    List<ApprovalLog> findByApprovalId(String approvalId);
}