package com.bcxin.ars.dao.sb;

import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.dto.page.ManagementInfoPageSearchDto;
import com.bcxin.ars.dto.sb.ManagementInfoDto;
import com.bcxin.ars.dto.sb.ManagementInfoSearchDto;
import com.bcxin.ars.model.sb.ManagementInfo;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;

import java.util.List;

public interface ManagementInfoDao {

	ManagementInfo findById(long id);

	List<ManagementInfo> findByAll();
	
	Long save(ManagementInfo managementInfo);
	
	void update(ManagementInfo managementInfo);
	
	List<ManagementInfo> search(ManagementInfoSearchDto dto);
	
	Long searchCount(ManagementInfoSearchDto dto);

	void delete(ManagementInfo managementInfo);

	List<ManagementInfo> searchForDataSynchronization(DataSynchronizationSearchDto searchDto);

	void saveForDS(ManagementInfo managementInfo);

	/**
	 * 用于管理层信息不完整的站内信通知
	 * @return 数据集
	 */
	List<ManagementInfoDto> listWithComId();

	/**
	 * 分页查询
	 * @param searchDto
	 * @param page
	 * @return
	 */
	List<ManagementInfo> searchForPage(ManagementInfoPageSearchDto searchDto, AjaxPageResponse<ManagementInfo> page);
}
