package com.bcxin.ars.dao.sb;

import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.dto.sb.GradePersonSearchDto;
import com.bcxin.ars.dto.sb.PersoncertificateSearchDto;
import com.bcxin.ars.model.sb.GradePerson;
import com.bcxin.ars.model.sb.Personcertificate;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Map;

/****
 * 等级证数据层
 * @author  subh
 */
public interface GradePersonDao {
    /***
     * 根据ID获取详细
     * @param id 主键
     * @return
     */
    GradePerson findById(Long id);
    /***
     * 插入
     * @param gradePerson
     */
    void insert(GradePerson gradePerson);
    /***
     * 更新
     * @param gradePerson
     */
    void update(GradePerson gradePerson);

    /**
     *
     * @Decription:批量更新
     * @param  gradePersonList 批量更新
     * @return
     */
    void updateBatch(@Param("gradePersonList") List<GradePerson> gradePersonList);
    /***
     * 批量插入
     * @param list 列表
     */
    void insertBatch(List<GradePerson> list);
    /***
     * 等级证查询
     * @param dto 查询条件参数
     * @param ajaxPageResponse 返回数据对象
     * @return 查询列表
     */
    List<GradePerson> query(GradePersonSearchDto dto, AjaxPageResponse<GradePerson> ajaxPageResponse);
    /**
     * 查询需要生成同步文件的等级证记录
     * @param dto
     * @return
     */
    List<GradePerson> searchForDataSynchronization(DataSynchronizationSearchDto dto);


    /**
     * 查询未背景筛查的
     * @return
     */
    List<GradePerson> findNoCensorStatus();


    /**
     * 内导外数据
     * @param startDate 开始时间
     * @return
     */
    List<GradePerson> searchForExport(String startDate);

    /****
     * 批量获取根据ID
     * @param list
     * @return
     */
    List<GradePerson> findByBatchId(List<GradePerson> list);
    /****
     * 批量获取根据身份证号
     * @param list
     * @return
     */
    List<GradePerson> findByBatchIdnum(List<GradePerson> list);


    /**
     * 导入人员对比数据到临时表
     * @param subList
     * @param  importBatchId 批次号
     */
    void insertTempBatchGradePersonImport(@Param("subList")List<Map<String, String>> subList, @Param("importBatchId") String importBatchId);
    /**
     * 验证导入的Excel是否有重复身份证数据
     * @param  importBatchId 批次号
     */
    void checkIdNumNoRepeat(String importBatchId);
    /**
     * 验证需要导入的数据身份证是否已存在比对人员库
     * @param  importBatchId 批次号
     * @param userId 用户ID
     */
    void checkInOtherCom(@Param("importBatchId")String importBatchId,@Param("userId") Long userId);
    /**
     * 批量插入比对人员数据
     * @param  importBatchId 批次号
     */
    void insertGradePersonInfo(String importBatchId);

    /**
     * @查询本次校验失败的导入对比人员信息
     * @param  importBatchId 批次号
     */
    List<Map<String, String>> getTempImportGradePersonList(String importBatchId);

    /**
     * 删除本次导入的对人员信息
     * @param  importBatchId 批次号
     */
    void deleteTempBatchGradePersonImport(String importBatchId);

    /***
     * 查询批量号列表
     * @return
     */
    List<String> queryImportBatchIdList(Long userId);


    /***
     * 统计申诉对比人员个数
     * @return
     */
    Long appealCount(@Param("orgId")Long orgId);

}
