package com.bcxin.ars.dao.msg;

import java.util.List;

import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.model.msg.NewsCompanyRelationship;
import org.apache.ibatis.annotations.Param;

public interface NewsCompanyRelationshipDao {
	
    void delete(NewsCompanyRelationship record);
    
    void deleteByNoticePoliceId(NewsCompanyRelationship record);

    Long save(NewsCompanyRelationship record);

    NewsCompanyRelationship findById(Long id);

    void update(NewsCompanyRelationship record);

	List<NewsCompanyRelationship> findByNoticePoliceId(Long noticePoliceId);

    void saveForDS(NewsCompanyRelationship newsCompanyRelationship);

    void updateForDS(NewsCompanyRelationship newsCompanyRelationship);

    /**
     * 内导外数据
     * @param startDate 开始时间
     * @return
     */
    List<NewsCompanyRelationship> searchFromInToOutForExport(String startDate);

    List<NewsCompanyRelationship> searchForDataSynchronization(DataSynchronizationSearchDto searchDto);

    List<NewsCompanyRelationship> findByBatchId(@Param("list")List<NewsCompanyRelationship> list);
    /**
     * @Decription:批量保存修改
     * @param list
     * @return
     */
    void saveBatch(@Param("list")List<NewsCompanyRelationship> list);
}