package com.bcxin.ars.dao.datasync;

import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.dto.page.DataSyncLogPageSearchDto;
import com.bcxin.ars.model.datasync.DataSyncLog;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 数据同步记录Dao接口
 * 
 * @author lin
 * @date 2020-12-07
 */
public interface DataSyncLogDao{

    /****
     * 删除
     * @param dataSyncLog
     * @return
     */
    int delete(DataSyncLog dataSyncLog);

    /****
     * 保存
     * @param dataSyncLog
     * @return
     */
    int save(DataSyncLog dataSyncLog);

    /****
     * 主键查询
     * @param id
     * @return
     */
        DataSyncLog findById(Long id);

    /****
     * 选择修改
     * @param dataSyncLog
     * @return
     */
    int updateSelective(DataSyncLog dataSyncLog);

    /**
     * 分页查询
     * @param searchDto
     * @param page
     * @return
     */
    List<DataSyncLog> searchForPage(DataSyncLogPageSearchDto searchDto, AjaxPageResponse<DataSyncLog> page);

    /**
     * 外导内查询
     * @param searchDto
     * @return
     */
    List<DataSyncLog> searchForDataSynchronization(DataSynchronizationSearchDto searchDto);

    /**
     * 内导外查询
     * @param startDate
     * @return
     */
    List<DataSyncLog> findDSOutList(String startDate);

    /**
     * 批量保存
     * @param list
     */
    void saveBatch(@Param("list") List<DataSyncLog> list);

    /**
     * 批量查询
     * @param list
     * @return
     */
    List<DataSyncLog> findByBatchId(@Param("list") List<DataSyncLog> list);


    DataSyncLog findByMsgId(String msgId);

    DataSyncLog findByFilePath(String filePath);

    List<DataSyncLog> findUnDataSyncList();

    String findUnDSTime();
}
