package com.bcxin.ars.dao.certificate;

import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.model.certificate.GradeAppraisalCer;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 *保安员等级证报名鉴定证书Dao
 * @author linqinglin
 * @Date 2020-02-04 10:50:12
 */
public interface GradeAppraisalCerDao {

   /****
     * 删除
     * @param gradeAppraisalCer
     * @return
     */
    int delete(GradeAppraisalCer gradeAppraisalCer);

    /****
     * 保存
     * @param gradeAppraisalCer
     * @return
     */
    int save(GradeAppraisalCer gradeAppraisalCer);

    /****
     * 新增
     * @param gradeAppraisalCer
     * @return
     */
    int insert(GradeAppraisalCer gradeAppraisalCer);

    /****
     * 选择性插入
     * @param gradeAppraisalCer
     * @return
     */
    int insertSelective(GradeAppraisalCer gradeAppraisalCer);

    /****
     * 主键查询
     * @param id
     * @return
     */
    GradeAppraisalCer findById(Long id);

    GradeAppraisalCer findByIdWithOutCache(Long id);

    /****
     * 修改
     * @param gradeAppraisalCer
     * @return
     */
    int update(GradeAppraisalCer gradeAppraisalCer);

    /****
     * 选择修改
     * @param gradeAppraisalCer
     * @return
     */
    int updateSelective(GradeAppraisalCer gradeAppraisalCer);

    /**
     * 外导内查询
     * @param searchDto
     * @return
     */
    List<GradeAppraisalCer> searchForDataSynchronization(DataSynchronizationSearchDto searchDto);

    /**
     * 内导外查询
     * @param startDate
     * @return
     */
    List<GradeAppraisalCer> findDSOutList(String startDate);

    /**
     * 批量保存
     * @param list
     */
    void saveBatch(@Param("list") List<GradeAppraisalCer> list);

    /**
     * 批量查询
     * @param list
     * @return
     */
    List<GradeAppraisalCer> findByBatchId(@Param("list") List<GradeAppraisalCer> list);

    List<GradeAppraisalCer> findByBatchIdWithOutCache(@Param("list") List<GradeAppraisalCer> list);

    /**
     * 根据报名id查询证书
     * @param personGradeId
     * @return
     */
    GradeAppraisalCer findByPersonGradeId(Long personGradeId);

    String getNextVal(String seqAppraisalCer);

    GradeAppraisalCer findByIdNum(String idNum);
}
