package com.bcxin.ars.dao;

import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.model.Role;

import java.util.List;

public interface RoleDao {

	Long save(Role role); 
	
	void update(Role role); 
	
	void delete(Role role);
	
	Role findById(Long id);
	
	List<Role> findByCompany(Long companyId);

	Role findByPersonId(Long personId);
	
	Role findByCompanyRoleName(Long companyId, String name);

	List<Role> searchForDataSynchronization(DataSynchronizationSearchDto dto);

	Long saveForDS(Role role);

	List<Role> findByUserId(Long userId);

    List<Role> findByUserIdCompanyId(Long userId, Long companyId);


	/****
	 * 根据公司ID查询角色全部
	 * @param companyId 公司ID
	 * @return 角色列表
	 */
	List<Role> findByCompanyAll(Long companyId);
}
