package com.bcxin.ars.dao;

import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.model.PersonBaseImg;
import com.bcxin.ars.model.PersonBaseInfo;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * @author linqinglin
 * @date 2019/09/19 0019 13:52
 */
public interface PersonBaseInfoDao {

    void insert(PersonBaseInfo personBaseInfo);

    void update(PersonBaseInfo personBaseInfo);

    PersonBaseInfo selectById(Long id);

    void updateFlagForOutToIn(List<PersonBaseInfo> list);

    List<PersonBaseInfo> searchForDataSynchronization(DataSynchronizationSearchDto dto);

    List<PersonBaseInfo> searchForExport(String startDate);

    List<PersonBaseInfo> findByBatchId(@Param("list")List<PersonBaseInfo> list);

    void saveBatch(@Param("list")List<PersonBaseInfo> list);

    /**
     *  查询转换列表
     * @return
     */
    List<PersonBaseImg> findByConver();

    /**
     * 图片转换更新
     * @param personBaseInfo
     */
    void updateImgBlob(PersonBaseInfo personBaseInfo);

    void updateImg(PersonBaseImg personBaseImg);

    PersonBaseInfo findByIdNum(String idnum);

    List<String> findUnGetBaseInfoListFormApproval();

    List<String> findUnGetBaseInfoListFormPerson();

    List<String> findUnGetBaseInfoListFormOldData();

    List<PersonBaseImg> prc_createData(@Param("fzrq") String fzrq);
}
