package com.bcxin.ars.dao;

import java.util.List;

import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.model.OrderTransaction;

/**
 * 交易订单数据访问类
 * @author Ethan
 */
public interface OrderTransactionDao {
	
	void save(OrderTransaction orderTransaction);

	public OrderTransaction findById(Long id);

	public OrderTransaction findByOrderId(Long orderId);

	void update(OrderTransaction transaction);

	OrderTransaction findByOrderNo(String orderNo);

	List<OrderTransaction> searchForDataSynchronization(DataSynchronizationSearchDto searchDto);

	void delete(OrderTransaction orderTransaction);

	void saveForDS(OrderTransaction orderTransaction);
}