package com.bcxin.ars.dao;

import com.bcxin.ars.dto.page.FilerecordPageSearchDto;
import com.bcxin.ars.dto.sb.FilerecordSearchDto;
import com.bcxin.ars.model.Filerecord;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import org.apache.ibatis.annotations.Param;

import java.util.List;

public interface FilerecordDao {
	

	/**
	 * 保存
	 * @param filerecord
	 * @return
	 */
	Long save(Filerecord filerecord);

	/**
	 * 根据ID查询
	 * @param id
	 * @return
	 */
	Filerecord findById(Long id);

	/**
	 * 删除
	 * @param id
	 */
	void delete(Long id);

	/**
	 * 根据filepath查询
	 * @param filepath
	 * @return
	 */
	Filerecord findByFilepath(String filepath);


	/**
	 *
	 * @Decription:查询一段日期内同步文件记录
	 * @author：wjb
	 * @method  findFilerecordByTime
	 * @date：2018年9月14日09:37:18
	 * @params： * @param startDate
	 * @return java.util.List<com.bcxin.ars.model.Filerecord>
	 */
    List<Filerecord> findFilerecordByTime(String startDate);

	/**
	 *
	 * @Decription:批量查询ID是否有在列表中
	 * @author：wjb
	 * @method  findByBatchId
	 * @date：2018年9月14日10:31:08
	 * @params： * @param filerecordList
	 * @return java.util.List<com.bcxin.ars.model.Filerecord>
	 */
	List<Filerecord> findByBatchId(@Param("filerecordList") List<Filerecord> filerecordList);

	/**
	 *
	 * @Decription:批量保存
	 * @author：wjb
	 * @method  saveBatch
	 * @date：2018年9月14日10:30:28
	 * @params： * @param filerecordList
	 */
	void saveBatch(@Param("filerecordList") List<Filerecord>  filerecordList);

	/**
	 * 分组查询
	 * @param dateStrAfterToday
	 * @param tomorrow
	 * @return
	 */
	List<Filerecord> findFilerecordGroupByTime(String dateStrAfterToday, String tomorrow);

    List<Filerecord> search(FilerecordSearchDto dto);

	Long count(FilerecordSearchDto dto);

    List<Filerecord> findByFileName(String fileName, boolean intranet);

	/**
	 * 批量更新修改标志
	 * @param list
	 */
	void updateFlagBatch(@Param("list") List<Filerecord> list);

	/**
	 * 分页查询
	 * @param searchDto
	 * @param page
	 * @return
	 */
	List<Filerecord> searchForPage(FilerecordPageSearchDto searchDto, AjaxPageResponse<Filerecord> page);
}
