package com.bcxin.ars.dao;

import java.util.List;

import com.bcxin.ars.dto.DataAuthSearchDto;
import com.bcxin.ars.model.DataAuth;
import com.bcxin.ars.model.Permission;
import org.apache.ibatis.annotations.Param;

public interface DataAuthDao {

	DataAuth findById(long id);
	
	Long save(DataAuth dataAuth);


    /***
     * 批量保存角色数据权限
     * @param list 数据权限列表
     */
    void insertBatch(@Param("list")List<DataAuth> list);
	
	void update(DataAuth dataAuth);
	
	List<DataAuth> search(DataAuthSearchDto dto);
	
	Long searchCount(DataAuthSearchDto dto);

	void delete(DataAuth dataAuth);
	
	List<DataAuth> findByOrgId(Long orgid);
	
	List<DataAuth> findByRoleId(Long roleid);

	void deleteByRole(Long roleid);

	List<DataAuth> selectByroleid(Long roleid);
	
	List<DataAuth> findAll();

	DataAuth findByRoleIdAndOrgId(Long roleid, Long orgid);

}
