package com.bcxin.ars.dao;

import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.dto.sb.CyServerhtSearchDto;
import com.bcxin.ars.model.CyServerht;

import java.util.List;

public interface CyServerhtDao {
	/**
	 * 查询
	 * @param cyServerhtSearchDto
	 * @return
	 */
	List<CyServerht> search(CyServerhtSearchDto cyServerhtSearchDto);

	/**
	 * 保存
	 * @param cyServerht
	 * @return
	 */
	Long save(CyServerht cyServerht);
	/**
	 * 通过id保存
	 * @param cyServerht
	 * @return
	 */
	Long saveById(CyServerht cyServerht);

	/**
	 * 删除
	 * @param cyServerht
	 * @return
	 */
	Long delete(CyServerht cyServerht);

	/**
	 * 根据ID查询
	 * @param id
	 * @return
	 */
	CyServerht findById(Long id);

	/**
	 * 统计
	 * @return
	 */
	long count(CyServerhtSearchDto dto);

	/**
	 * 更新投诉建议信息
	 * @param cyServerht
	 */
	void update(CyServerht cyServerht);

	List<CyServerht> searchForDataSynchronization(DataSynchronizationSearchDto searchDto);

	void saveForDS(CyServerht cyServerht);

	Long countGroupByServerObjByUserId(Long userid);


}
