/*
 * Decompiled with CFR 0.152.
 */
package com.abcxin.smart.core.persistence.interceptor;

import com.abcxin.smart.core.persistence.IDialect;
import com.abcxin.smart.core.persistence.dialect.MySqlDialect;
import com.abcxin.smart.core.persistence.dialect.OracleDialect;
import com.abcxin.smart.validator.annotation.ModelAnnotation;
import com.abcxin.smart.validator.annotation.ModelTableAnnotation;
import com.abcxin.smart.validator.util.JsqlparserUtil;
import com.abcxin.smart.validator.util.SingletonMapCopyUtils;
import com.alibaba.fastjson.JSON;
import com.bcxin.ars.dto.PropertiesDTO;
import com.bcxin.ars.model.User;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import com.mysql.jdbc.StringUtils;
import java.lang.reflect.Field;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.DateFormat;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Pattern;
import net.sf.jsqlparser.statement.update.Update;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.executor.statement.StatementHandler;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.ParameterMapping;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.reflection.SystemMetaObject;
import org.apache.ibatis.scripting.defaults.DefaultParameterHandler;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.session.ResultHandler;
import org.apache.ibatis.session.RowBounds;
import org.apache.ibatis.type.TypeHandlerRegistry;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.session.Session;
import org.apache.shiro.subject.Subject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Intercepts(value={@Signature(type=StatementHandler.class, method="prepare", args={Connection.class}), @Signature(type=Executor.class, method="query", args={MappedStatement.class, Object.class, RowBounds.class, ResultHandler.class})})
public class PaginationInterceptor
implements Interceptor {
    private static final Logger log = LoggerFactory.getLogger(PaginationInterceptor.class);
    private static Pattern sqlPattern = Pattern.compile("(\\()(.*?)(\\))");
    private String dialectType;
    private IDialect dialect;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object intercept(Invocation invocation) throws Throwable {
        RowBounds rowBounds;
        Object target = invocation.getTarget();
        String methodName = invocation.getMethod().getName();
        if (methodName.equals("prepare")) {
            AjaxPageResponse pagination;
            StatementHandler statementHandler = (StatementHandler)target;
            MetaObject metaStatementHandler = SystemMetaObject.forObject((Object)statementHandler);
            Object bounds = metaStatementHandler.getValue("delegate.rowBounds");
            RowBounds rowBounds2 = (RowBounds)bounds;
            MappedStatement mappedStatement = (MappedStatement)metaStatementHandler.getValue("delegate.mappedStatement");
            Connection connection = (Connection)invocation.getArgs()[0];
            BoundSql boundSql = (BoundSql)metaStatementHandler.getValue("delegate.boundSql");
            String originalSql = boundSql.getSql();
            String sqlId = mappedStatement.getId();
            Configuration configuration = mappedStatement.getConfiguration();
            if (rowBounds2 == null || rowBounds2 == RowBounds.DEFAULT) {
                return invocation.proceed();
            }
            if (this.dialect == null) {
                PaginationInterceptor paginationInterceptor = this;
                synchronized (paginationInterceptor) {
                    if (this.dialect == null) {
                        String productName = connection.getMetaData().getDatabaseProductName();
                        if (log.isTraceEnabled()) {
                            log.trace("\u6570\u636e\u5e93\u4ea7\u54c1\u540d\u79f0: " + productName);
                        }
                        if ((productName = productName.toLowerCase()).indexOf("mysql") != -1) {
                            this.dialectType = "mysql";
                            this.dialect = new MySqlDialect();
                        } else if (productName.indexOf("oracle") != -1) {
                            this.dialectType = "oracle";
                            this.dialect = new OracleDialect();
                        }
                        if (this.dialect == null) {
                            throw new IllegalArgumentException("\u6ca1\u6709\u9002\u5408\u6570\u636e\u5e93" + productName + "\u7684\u65b9\u8a00\u7c7b\uff08\u7528\u4e8e\u81ea\u52a8\u5206\u9875\u7b49\uff09");
                        }
                        if (log.isInfoEnabled()) {
                            log.info("\u81ea\u52a8\u68c0\u6d4b\u5230\u7684\u6570\u636e\u5e93\u7c7b\u578b\u4e3a: " + this.dialectType);
                        }
                    }
                }
            }
            String paginationSql = "";
            if (bounds instanceof AjaxPageResponse) {
                pagination = (AjaxPageResponse)bounds;
                if (!pagination.isPagination()) return invocation.proceed();
                int offset = (pagination.getPageNumber() - 1) * pagination.getPageSize();
                if (!StringUtils.isNullOrEmpty((String)pagination.getSort()) && !StringUtils.isNullOrEmpty((String)pagination.getOrder())) {
                    originalSql = originalSql + " ORDER BY " + pagination.getSort() + " " + pagination.getOrder();
                }
                paginationSql = this.dialect.buildPaginationSql(originalSql, offset, pagination.getPageSize());
            } else {
                paginationSql = this.dialect.buildPaginationSql(originalSql, rowBounds2.getOffset(), rowBounds2.getLimit());
            }
            metaStatementHandler.setValue("delegate.boundSql.sql", (Object)paginationSql);
            metaStatementHandler.setValue("delegate.rowBounds.offset", (Object)0);
            metaStatementHandler.setValue("delegate.rowBounds.limit", (Object)Integer.MAX_VALUE);
            if (!(bounds instanceof AjaxPageResponse) || (pagination = (AjaxPageResponse)bounds).getTotal() != 0L) return invocation.proceed();
            this.count(originalSql, connection, mappedStatement, boundSql, pagination);
            return invocation.proceed();
        }
        if (!methodName.equals("query") || !((rowBounds = (RowBounds)invocation.getArgs()[2]) instanceof AjaxPageResponse)) return invocation.proceed();
        AjaxPageResponse pagination = (AjaxPageResponse)rowBounds;
        Object data = invocation.proceed();
        if (!(data instanceof List)) return data;
        pagination.setData((List)data);
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void count(String sql, Connection connection, MappedStatement mappedStatement, BoundSql boundSql, AjaxPageResponse page) {
        String countSql = null;
        ArrayList<ParameterMapping> newList = new ArrayList<ParameterMapping>();
        List oldParams = boundSql.getParameterMappings();
        if (oldParams != null) {
            for (ParameterMapping oldParam : oldParams) {
                newList.add(oldParam);
            }
        }
        try {
            countSql = JsqlparserUtil.getCountSql((String)sql, newList);
            System.out.println(countSql);
        }
        catch (Exception e) {
            log.error("\u73b0\u6709\u5206\u9875\u4e0d\u652f\u6301\u590d\u6742\u67e5\u8be2sql:" + sql + "\u4f7f\u7528\u9ed8\u8ba4\u5206\u9875");
            countSql = "SELECT COUNT(0) FROM (" + sql + ") as total";
        }
        log.debug("\u5206\u9875\u65f6, \u751f\u6210countSql: " + countSql);
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            pstmt = connection.prepareStatement(countSql);
            BoundSql countBS = new BoundSql(mappedStatement.getConfiguration(), countSql, newList, boundSql.getParameterObject());
            DefaultParameterHandler parameterHandler = new DefaultParameterHandler(mappedStatement, boundSql.getParameterObject(), countBS);
            parameterHandler.setParameters(pstmt);
            rs = pstmt.executeQuery();
            long total = 0L;
            if (rs.next()) {
                total = rs.getLong(1);
            }
            page.setTotal(total);
        }
        catch (SQLException e) {
            log.error("\u67e5\u8be2\u603b\u6570\u51fa\u9519", (Throwable)e);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception e) {
                    log.error("\u5173\u95edResultSet\u65f6\u5f02\u5e38.", (Throwable)e);
                }
            }
            if (pstmt != null) {
                try {
                    pstmt.close();
                }
                catch (Exception e) {
                    log.error("\u5173\u95edPreparedStatement\u65f6\u5f02\u5e38.", (Throwable)e);
                }
            }
        }
    }

    public Object plugin(Object target) {
        return Plugin.wrap((Object)target, (Interceptor)this);
    }

    public void setProperties(Properties properties) {
        String dialectType = properties.getProperty("dialectType");
        if (dialectType != null && !"".equals(dialectType.trim())) {
            this.dialectType = dialectType;
        }
        if (dialectType != null && !"".equals(dialectType)) {
            switch (dialectType.toLowerCase()) {
                case "mysql": {
                    this.dialect = new MySqlDialect();
                    break;
                }
                case "oracle": {
                    this.dialect = new OracleDialect();
                    break;
                }
            }
        }
    }

    private static String getParameterValue(Object obj) {
        String value = null;
        if (obj instanceof String) {
            value = "'" + obj.toString() + "'";
        } else if (obj instanceof Date) {
            DateFormat formatter = DateFormat.getDateTimeInstance(2, 2, Locale.CHINA);
            value = "'" + formatter.format(obj) + "'";
        } else {
            value = obj != null ? obj.toString() : "null";
        }
        value = value.replaceAll("getResource.do\\?path=", "").replaceAll("\\?", "");
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveOperationSqlLog(Connection connection, MappedStatement mappedStatement, String sql) throws Throwable {
        log.info("\u4fdd\u5b58Sql: " + sql);
        Statement pstmt = null;
        ResultSet rs = null;
        try {
            Update updateStatement = JsqlparserUtil.getUpdateStatement((String)sql);
            List tableNames = JsqlparserUtil.getTableNames((Update)updateStatement, (String)sql);
            if (tableNames != null && tableNames.size() == 1) {
                Map setColumns = JsqlparserUtil.getSetColumns((Update)updateStatement, (String)sql);
                Map whereColumns = JsqlparserUtil.getWhereColumns((Update)updateStatement, (String)sql);
                if (whereColumns.get("id") != null && !"?".equals(whereColumns.get("id"))) {
                    String triLogId = "";
                    pstmt = connection.prepareStatement("SELECT nextval('seq_triLogId')");
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        triLogId = rs.getString(1);
                    }
                    DateTimeFormatter format = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
                    pstmt = connection.prepareStatement("INSERT INTO `tri_log` (`triLogId`, `createTime`, `triType`, `ddlType`, `tableName`, `tablePrmKey`, `dbUser`,`dbUserRealName`) VALUES (?, ?, ?, ?, ?, ?, ?, ? )");
                    pstmt.setString(1, triLogId);
                    pstmt.setString(2, LocalDateTime.now().format(format));
                    pstmt.setString(3, "BEFORE");
                    pstmt.setString(4, "update");
                    PropertiesDTO propertiesDTO = (PropertiesDTO)JSON.parseObject((String)((String)SingletonMapCopyUtils.mapProperties.get(tableNames.get(0))), PropertiesDTO.class);
                    HashMap<String, String> mapColumns = new HashMap<String, String>();
                    HashMap<String, String> mapCodeColumns = new HashMap<String, String>();
                    if (null != propertiesDTO) {
                        Field[] fields;
                        Class<?> classParameter = Class.forName(propertiesDTO.getModelPath());
                        String tableName = "";
                        if (classParameter.isAnnotationPresent(ModelTableAnnotation.class)) {
                            ModelTableAnnotation tableAnnotation = classParameter.getAnnotation(ModelTableAnnotation.class);
                            tableName = tableAnnotation.getName();
                        }
                        pstmt.setString(5, (String)tableNames.get(0) + (tableName == null ? "" : tableName));
                        for (Field field : fields = classParameter.getDeclaredFields()) {
                            if (!field.isAnnotationPresent(ModelAnnotation.class)) continue;
                            ModelAnnotation resource = field.getAnnotation(ModelAnnotation.class);
                            mapColumns.put(resource.column(), resource.getName());
                            if (resource.needTranslate()) {
                                mapCodeColumns.put(resource.column(), resource.getName());
                            }
                            if (null == resource.dictName()) continue;
                            mapCodeColumns.put(resource.column(), resource.dictName());
                        }
                    } else {
                        pstmt.setString(5, (String)tableNames.get(0));
                    }
                    pstmt.setString(6, whereColumns.get("id") == null ? "" : (String)whereColumns.get("id"));
                    String dbUser = "system";
                    String dbUserRealName = "\u7cfb\u7edf";
                    if (SecurityUtils.getSubject() != null) {
                        Subject currentUser = SecurityUtils.getSubject();
                        Session session = currentUser.getSession();
                        User user = null;
                        if (session.getAttribute((Object)"user") != null) {
                            user = (User)session.getAttribute((Object)"user");
                            dbUser = user.getId().toString();
                            dbUserRealName = user.getRealname();
                        }
                    }
                    pstmt.setString(7, dbUser);
                    pstmt.setString(8, dbUserRealName);
                    pstmt.execute();
                    String querySql = JsqlparserUtil.getQuerySql((Update)updateStatement, (String)sql);
                    pstmt = connection.prepareStatement(querySql);
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        for (String key : setColumns.keySet()) {
                            String dbValue = rs.getString(key);
                            String newValue = (String)setColumns.get(key);
                            if (!StringUtils.isNullOrEmpty((String)((String)mapCodeColumns.get(key)))) {
                                dbValue = (String)SingletonMapCopyUtils.mapCode.get(key.toUpperCase() + dbValue);
                                newValue = (String)SingletonMapCopyUtils.mapCode.get(key.toUpperCase() + newValue.replaceAll("'", ""));
                                if (StringUtils.isNullOrEmpty((String)dbValue)) {
                                    dbValue = (String)SingletonMapCopyUtils.mapCode.get(((String)mapCodeColumns.get(key)).toUpperCase() + rs.getString(key));
                                }
                                if (StringUtils.isNullOrEmpty((String)newValue)) {
                                    newValue = (String)SingletonMapCopyUtils.mapCode.get(((String)mapCodeColumns.get(key)).toUpperCase() + ((String)setColumns.get(key)).replaceAll("'", ""));
                                }
                            }
                            if (StringUtils.isNullOrEmpty((String)dbValue)) {
                                dbValue = "";
                            }
                            if (StringUtils.isNullOrEmpty((String)newValue)) {
                                newValue = "";
                            } else {
                                if (newValue.startsWith("'")) {
                                    newValue = newValue.substring(1);
                                }
                                if (newValue.endsWith("'")) {
                                    newValue = newValue.substring(0, newValue.length() - 1);
                                }
                                if (newValue.toLowerCase().equals("true")) {
                                    newValue = "1";
                                }
                                if (newValue.toLowerCase().equals("false")) {
                                    newValue = "0";
                                }
                                if (newValue.toLowerCase().equals("null")) {
                                    newValue = "";
                                }
                            }
                            if (dbValue.equals(newValue)) continue;
                            pstmt = connection.prepareStatement("INSERT INTO `tri_log_detail` (`createTime`, `changeColumn`, `oldValue`, `newValue`, `triLogId`) VALUES (?, ?, ?, ?, ?)");
                            pstmt.setString(1, LocalDateTime.now().format(format));
                            pstmt.setString(2, key + (mapColumns.get(key) == null ? "" : (String)mapColumns.get(key)));
                            pstmt.setString(3, dbValue);
                            pstmt.setString(4, newValue);
                            pstmt.setString(5, triLogId);
                            pstmt.execute();
                        }
                    }
                    String sqlId = mappedStatement.getId();
                    String[] args = new String[]{LocalDateTime.now().format(format), sqlId, sql, triLogId};
                    pstmt = connection.prepareStatement("insert into operationSqlLog(`create_time`,`sqlId`,`sql`,`id`) VALUES(?,?,?,?)");
                    for (int i = 0; i < args.length; ++i) {
                        pstmt.setString(i + 1, args[i]);
                    }
                    pstmt.execute();
                }
            }
        }
        catch (SQLException e) {
            log.error("\u8bb0\u5f55\u64cd\u4f5c\u65e5\u5fd7\u51fa\u9519\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u5e93\u4e2d\u8868operationSqlLog\u3001tri_log_detail\u3001tri_log\u662f\u5426\u5b58\u5728\uff0c\u53ca\u51fd\u6570nextval\u3001currval\u662f\u5426\u5b58\u5728", (Throwable)e);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception e) {
                    log.error("\u5173\u95edResultSet\u65f6\u5f02\u5e38.", (Throwable)e);
                }
            }
            if (pstmt != null) {
                try {
                    pstmt.close();
                }
                catch (Exception e) {
                    log.error("\u5173\u95edPreparedStatement\u65f6\u5f02\u5e38.", (Throwable)e);
                }
            }
        }
    }

    public static String getSql(String sqlId, Configuration configuration, BoundSql boundSql) {
        Object parameterObject = boundSql.getParameterObject();
        List parameterMappings = boundSql.getParameterMappings();
        String sql = boundSql.getSql().replaceAll("[\\s]+", " ");
        if (parameterMappings.size() > 0 && parameterObject != null) {
            TypeHandlerRegistry typeHandlerRegistry = configuration.getTypeHandlerRegistry();
            if (typeHandlerRegistry.hasTypeHandler(parameterObject.getClass())) {
                sql = sql.replaceFirst("\\?", PaginationInterceptor.getParameterValue(parameterObject));
            } else {
                MetaObject metaObject = configuration.newMetaObject(parameterObject);
                for (ParameterMapping parameterMapping : parameterMappings) {
                    Object obj;
                    String propertyName = parameterMapping.getProperty();
                    if (metaObject.hasGetter(propertyName)) {
                        obj = metaObject.getValue(propertyName);
                        sql = sql.replaceFirst("\\?", PaginationInterceptor.getParameterValue(obj));
                        continue;
                    }
                    if (boundSql.hasAdditionalParameter(propertyName)) {
                        obj = boundSql.getAdditionalParameter(propertyName);
                        sql = sql.replaceFirst("\\?", PaginationInterceptor.getParameterValue(obj));
                        continue;
                    }
                    Map map = (Map)metaObject;
                    sql = sql.replaceFirst("\\?", PaginationInterceptor.getParameterValue(map.get(propertyName)));
                }
            }
        }
        log.info(sqlId + ":" + sql);
        return sql;
    }
}

