/*
 * Decompiled with CFR 0.152.
 */
package cn.wildfirechat.sdk.utilities;

import cn.wildfirechat.sdk.model.IMResult;
import cn.wildfirechat.sdk.utilities.JsonUtils;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.concurrent.TimeUnit;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.DefaultHttpRequestRetryHandler;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AdminHttpUtils
extends JsonUtils {
    private static final Logger LOG = LoggerFactory.getLogger(AdminHttpUtils.class);
    public static final Gson gson = new GsonBuilder().disableHtmlEscaping().create();
    private static String adminUrl;
    private static String adminSecret;
    private static CloseableHttpClient httpClient;

    public static void init(String url, String secret) {
        adminUrl = url;
        adminSecret = secret;
        PoolingHttpClientConnectionManager cm = new PoolingHttpClientConnectionManager();
        cm.setValidateAfterInactivity(1000);
        httpClient = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)cm).evictExpiredConnections().evictIdleConnections(60L, TimeUnit.SECONDS).setRetryHandler((HttpRequestRetryHandler)DefaultHttpRequestRetryHandler.INSTANCE).setMaxConnTotal(100).setMaxConnPerRoute(50).build();
    }

    public static <T> IMResult<T> httpGet(String path, Class<T> clazz) throws Exception {
        if (AdminHttpUtils.isNullOrEmpty(adminUrl) || AdminHttpUtils.isNullOrEmpty(adminSecret)) {
            LOG.error("\u91ce\u706bIM Server SDK\u5fc5\u987b\u5148\u521d\u59cb\u5316\u624d\u80fd\u4f7f\u7528\uff0c\u662f\u4e0d\u662f\u5fd8\u8bb0\u521d\u59cb\u5316\u4e86\uff01\uff01\uff01\uff01");
            throw new Exception("SDK\u6ca1\u6709\u521d\u59cb\u5316");
        }
        if (AdminHttpUtils.isNullOrEmpty(path)) {
            throw new Exception("\u8def\u5f84\u7f3a\u5931");
        }
        HttpGet get = null;
        try {
            get = new HttpGet(adminUrl + path);
            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)get);
            int statusCode = response.getStatusLine().getStatusCode();
            String content = null;
            if (response.getEntity().getContentLength() > 0L) {
                String line;
                BufferedReader in = new BufferedReader(new InputStreamReader(response.getEntity().getContent(), "utf-8"));
                StringBuilder sb = new StringBuilder();
                String NL = System.getProperty("line.separator");
                while ((line = in.readLine()) != null) {
                    sb.append(line).append(NL);
                }
                in.close();
                content = sb.toString();
                LOG.info("http request response content: {}", (Object)content);
            }
            if (statusCode != 200) {
                LOG.info("Request error: " + statusCode + " error msg:" + content);
                throw new Exception("Http request error with code:" + statusCode);
            }
            IMResult<T> iMResult = AdminHttpUtils.fromJsonObject(content, clazz);
            return iMResult;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        finally {
            if (get != null) {
                get.releaseConnection();
            }
        }
    }

    public static <T> IMResult<T> httpJsonPost(String path, Object object, Class<T> clazz) throws Exception {
        if (AdminHttpUtils.isNullOrEmpty(adminUrl) || AdminHttpUtils.isNullOrEmpty(adminSecret)) {
            LOG.error("\u91ce\u706bIM Server SDK\u5fc5\u987b\u5148\u521d\u59cb\u5316\u624d\u80fd\u4f7f\u7528\uff0c\u662f\u4e0d\u662f\u5fd8\u8bb0\u521d\u59cb\u5316\u4e86\uff01\uff01\uff01\uff01");
            throw new Exception("SDK\u6ca1\u6709\u521d\u59cb\u5316");
        }
        if (AdminHttpUtils.isNullOrEmpty(path)) {
            throw new Exception("\u8def\u5f84\u7f3a\u5931");
        }
        String url = adminUrl + path;
        HttpPost post = null;
        try {
            int nonce = (int)(Math.random() * 100000.0 + 3.0);
            long timestamp = System.currentTimeMillis();
            String str = nonce + "|" + adminSecret + "|" + timestamp;
            String sign = DigestUtils.sha1Hex((String)str);
            post = new HttpPost(url);
            post.setHeader("Content-type", "application/json; charset=utf-8");
            post.setHeader("Connection", "Keep-Alive");
            post.setHeader("nonce", nonce + "");
            post.setHeader("timestamp", "" + timestamp);
            post.setHeader("sign", sign);
            String jsonStr = "";
            if (object != null) {
                jsonStr = gson.toJson(object);
            }
            LOG.info("http request:{} content: {}", (Object)path, (Object)jsonStr);
            StringEntity entity = new StringEntity(jsonStr, Charset.forName("UTF-8"));
            entity.setContentEncoding("UTF-8");
            entity.setContentType("application/json");
            post.setEntity((HttpEntity)entity);
            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)post);
            int statusCode = response.getStatusLine().getStatusCode();
            String content = null;
            if (response.getEntity().getContentLength() > 0L) {
                String line;
                BufferedReader in = new BufferedReader(new InputStreamReader(response.getEntity().getContent(), "utf-8"));
                StringBuilder sb = new StringBuilder();
                String NL = System.getProperty("line.separator");
                while ((line = in.readLine()) != null) {
                    sb.append(line).append(NL);
                }
                in.close();
                content = sb.toString();
                LOG.info("http request response content: {}", (Object)content);
            }
            if (statusCode != 200) {
                LOG.info("Request error: " + statusCode + " error msg:" + content);
                throw new Exception("Http request error with code:" + statusCode);
            }
            IMResult<T> iMResult = AdminHttpUtils.fromJsonObject(content, clazz);
            return iMResult;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        finally {
            if (post != null) {
                post.releaseConnection();
            }
        }
    }
}

