/*
 * Decompiled with CFR 0.152.
 */
package cn.wildfirechat.sdk;

import cn.wildfirechat.pojos.BroadMessageData;
import cn.wildfirechat.pojos.BroadMessageResult;
import cn.wildfirechat.pojos.Conversation;
import cn.wildfirechat.pojos.DeleteMessageData;
import cn.wildfirechat.pojos.InputClearUserMessages;
import cn.wildfirechat.pojos.InputGetConvReadTime;
import cn.wildfirechat.pojos.InputMessageUid;
import cn.wildfirechat.pojos.InputUserConversation;
import cn.wildfirechat.pojos.InputUserId;
import cn.wildfirechat.pojos.MessagePayload;
import cn.wildfirechat.pojos.MultiMessageResult;
import cn.wildfirechat.pojos.MulticastMessageData;
import cn.wildfirechat.pojos.OutputMessageData;
import cn.wildfirechat.pojos.OutputTimestamp;
import cn.wildfirechat.pojos.RecallMessageData;
import cn.wildfirechat.pojos.RecallMultiCastMessageData;
import cn.wildfirechat.pojos.SendMessageData;
import cn.wildfirechat.pojos.SendMessageResult;
import cn.wildfirechat.pojos.UpdateMessageContentData;
import cn.wildfirechat.sdk.model.IMResult;
import cn.wildfirechat.sdk.utilities.AdminHttpUtils;
import java.util.List;

public class MessageAdmin {
    public static IMResult<SendMessageResult> sendMessage(String sender, Conversation conversation, MessagePayload payload) throws Exception {
        return MessageAdmin.sendMessage(sender, conversation, payload, null);
    }

    public static IMResult<SendMessageResult> sendMessage(String sender, Conversation conversation, MessagePayload payload, List<String> toUsers) throws Exception {
        String path = "/admin/message/send";
        SendMessageData messageData = new SendMessageData();
        messageData.setSender(sender);
        messageData.setConv(conversation);
        messageData.setPayload(payload);
        messageData.setToUsers(toUsers);
        if (payload.getType() == 1 && (payload.getSearchableContent() == null || payload.getSearchableContent().isEmpty())) {
            System.out.println("Payload\u9519\u8bef\uff0cPayload\u683c\u5f0f\u5e94\u8be5\u8ddf\u5ba2\u6237\u7aef\u6d88\u606fencode\u51fa\u6765\u7684Payload\u5bf9\u9f50\uff0c\u8fd9\u6837\u5ba2\u6237\u7aef\u624d\u80fd\u6b63\u786e\u8bc6\u522b\u3002\u6bd4\u5982\u6587\u672c\u6d88\u606f\uff0c\u6587\u672c\u9700\u8981\u653e\u5230searchableContent\u5c5e\u6027\u3002\u8bf7\u4e0e\u5ba2\u6237\u7aef\u540c\u4e8b\u786e\u8ba4Payload\u7684\u683c\u5f0f\uff0c\u6216\u5219\u53bb https://gitee.com/wfchat/android-chat/tree/master/client/src/main/java/cn/wildfirechat/message \u627e\u5230\u6d88\u606fencode\u7684\u5b9e\u73b0\u65b9\u6cd5\uff01");
        }
        return AdminHttpUtils.httpJsonPost(path, messageData, SendMessageResult.class);
    }

    public static IMResult<Void> recallMessage(String operator, long messageUid) throws Exception {
        String path = "/admin/message/recall";
        RecallMessageData messageData = new RecallMessageData();
        messageData.setOperator(operator);
        messageData.setMessageUid(messageUid);
        return AdminHttpUtils.httpJsonPost(path, messageData, Void.class);
    }

    public static IMResult<Void> deleteMessage(long messageUid) throws Exception {
        String path = "/admin/message/delete";
        DeleteMessageData deleteMessageData = new DeleteMessageData();
        deleteMessageData.setMessageUid(messageUid);
        return AdminHttpUtils.httpJsonPost(path, deleteMessageData, Void.class);
    }

    public static IMResult<Void> clearUserMessages(String userId, Conversation conversation, long fromTime, long toTime) throws Exception {
        String path = "/admin/message/clear_by_user";
        InputClearUserMessages clearUserMessages = new InputClearUserMessages(userId, conversation, fromTime, toTime);
        return AdminHttpUtils.httpJsonPost(path, clearUserMessages, Void.class);
    }

    public static IMResult<Void> updateMessageContent(String operator, long messageUid, MessagePayload payload, boolean distribute) throws Exception {
        String path = "/admin/message/update";
        UpdateMessageContentData updateMessageContentData = new UpdateMessageContentData();
        updateMessageContentData.setOperator(operator);
        updateMessageContentData.setMessageUid(messageUid);
        updateMessageContentData.setPayload(payload);
        updateMessageContentData.setDistribute(distribute ? 1 : 0);
        updateMessageContentData.setUpdateTimestamp(0);
        return AdminHttpUtils.httpJsonPost(path, updateMessageContentData, Void.class);
    }

    public static IMResult<Void> clearConversation(String userId, Conversation conversation) throws Exception {
        String path = "/admin/conversation/delete";
        InputUserConversation input = new InputUserConversation();
        input.userId = userId;
        input.conversation = conversation;
        return AdminHttpUtils.httpJsonPost(path, input, Void.class);
    }

    public static IMResult<OutputMessageData> getMessage(long messageUid) throws Exception {
        String path = "/admin/message/get_one";
        InputMessageUid inputMessageUid = new InputMessageUid(messageUid);
        return AdminHttpUtils.httpJsonPost(path, inputMessageUid, OutputMessageData.class);
    }

    public static IMResult<Void> recallBroadCastMessage(String operator, long messageUid) throws Exception {
        String path = "/admin/message/recall_broadcast";
        RecallMessageData messageData = new RecallMessageData();
        messageData.setOperator(operator);
        messageData.setMessageUid(messageUid);
        return AdminHttpUtils.httpJsonPost(path, messageData, Void.class);
    }

    public static IMResult<Void> recallMultiCastMessage(String operator, long messageUid, List<String> receivers) throws Exception {
        String path = "/admin/message/recall_multicast";
        RecallMultiCastMessageData messageData = new RecallMultiCastMessageData();
        messageData.operator = operator;
        messageData.messageUid = messageUid;
        messageData.receivers = receivers;
        return AdminHttpUtils.httpJsonPost(path, messageData, Void.class);
    }

    public static IMResult<BroadMessageResult> broadcastMessage(String sender, int line, MessagePayload payload) throws Exception {
        String path = "/admin/message/broadcast";
        BroadMessageData messageData = new BroadMessageData();
        messageData.setSender(sender);
        messageData.setLine(line);
        messageData.setPayload(payload);
        return AdminHttpUtils.httpJsonPost(path, messageData, BroadMessageResult.class);
    }

    public static IMResult<MultiMessageResult> multicastMessage(String sender, List<String> receivers, int line, MessagePayload payload) throws Exception {
        String path = "/admin/message/multicast";
        MulticastMessageData messageData = new MulticastMessageData();
        messageData.setSender(sender);
        messageData.setTargets(receivers);
        messageData.setLine(line);
        messageData.setPayload(payload);
        return AdminHttpUtils.httpJsonPost(path, messageData, MultiMessageResult.class);
    }

    public static IMResult<OutputTimestamp> getConversationReadTimestamp(String userId, Conversation conversation) throws Exception {
        String path = "/admin/message/conv_read";
        InputGetConvReadTime input = new InputGetConvReadTime(userId, conversation.getType(), conversation.getTarget(), conversation.getLine());
        return AdminHttpUtils.httpJsonPost(path, input, OutputTimestamp.class);
    }

    public static IMResult<OutputTimestamp> getMessageDelivery(String userId) throws Exception {
        String path = "/admin/message/delivery";
        InputUserId input = new InputUserId(userId);
        return AdminHttpUtils.httpJsonPost(path, input, OutputTimestamp.class);
    }
}

