/*
 * Decompiled with CFR 0.152.
 */
package cn.wildfirechat.pojos;

import cn.wildfirechat.proto.WFCMessage;
import com.google.protobuf.ByteString;
import io.netty.util.internal.StringUtil;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;

public class MessagePayload {
    private int type;
    private String searchableContent;
    private String pushContent;
    private String pushData;
    private String content;
    private String base64edData;
    private int mediaType;
    private String remoteMediaUrl;
    private int persistFlag;
    private int expireDuration;
    private int mentionedType;
    private List<String> mentionedTarget;
    private String extra;

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public String getSearchableContent() {
        return this.searchableContent;
    }

    public void setSearchableContent(String searchableContent) {
        this.searchableContent = searchableContent;
    }

    public String getPushContent() {
        return this.pushContent;
    }

    public void setPushContent(String pushContent) {
        this.pushContent = pushContent;
    }

    public String getContent() {
        return this.content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public String getBase64edData() {
        return this.base64edData;
    }

    public void setBase64edData(String base64edData) {
        this.base64edData = base64edData;
    }

    public int getMediaType() {
        return this.mediaType;
    }

    public void setMediaType(int mediaType) {
        this.mediaType = mediaType;
    }

    public String getRemoteMediaUrl() {
        return this.remoteMediaUrl;
    }

    public void setRemoteMediaUrl(String remoteMediaUrl) {
        this.remoteMediaUrl = remoteMediaUrl;
    }

    public int getPersistFlag() {
        return this.persistFlag;
    }

    public void setPersistFlag(int persistFlag) {
        this.persistFlag = persistFlag;
    }

    public int getExpireDuration() {
        return this.expireDuration;
    }

    public void setExpireDuration(int expireDuration) {
        this.expireDuration = expireDuration;
    }

    public int getMentionedType() {
        return this.mentionedType;
    }

    public void setMentionedType(int mentionedType) {
        this.mentionedType = mentionedType;
    }

    public List<String> getMentionedTarget() {
        return this.mentionedTarget;
    }

    public void setMentionedTarget(List<String> mentionedTarget) {
        this.mentionedTarget = mentionedTarget;
    }

    public String getExtra() {
        return this.extra;
    }

    public void setExtra(String extra) {
        this.extra = extra;
    }

    public String getPushData() {
        return this.pushData;
    }

    public void setPushData(String pushData) {
        this.pushData = pushData;
    }

    public WFCMessage.MessageContent toProtoMessageContent() {
        WFCMessage.MessageContent.Builder builder = WFCMessage.MessageContent.newBuilder().setType(this.type).setMediaType(this.mediaType).setPersistFlag(this.persistFlag).setExpireDuration(this.expireDuration).setMentionedType(this.mentionedType);
        if (!StringUtil.isNullOrEmpty((String)this.searchableContent)) {
            builder.setSearchableContent(this.searchableContent);
        }
        if (!StringUtil.isNullOrEmpty((String)this.pushContent)) {
            builder.setPushContent(this.pushContent);
        }
        if (!StringUtil.isNullOrEmpty((String)this.content)) {
            builder.setContent(this.content);
        }
        if (!StringUtil.isNullOrEmpty((String)this.base64edData)) {
            builder.setData(ByteString.copyFrom((byte[])Base64.getDecoder().decode(this.base64edData)));
        }
        if (!StringUtil.isNullOrEmpty((String)this.remoteMediaUrl)) {
            builder.setRemoteMediaUrl(this.remoteMediaUrl);
        }
        if (this.mentionedTarget != null && this.mentionedTarget.size() > 0) {
            builder.addAllMentionedTarget(this.mentionedTarget);
        }
        if (!StringUtil.isNullOrEmpty((String)this.extra)) {
            builder.setExtra(this.extra);
        }
        if (!StringUtil.isNullOrEmpty((String)this.pushData)) {
            builder.setPushData(this.pushData);
        }
        return builder.build();
    }

    public static MessagePayload fromProtoMessageContent(WFCMessage.MessageContent protoContent) {
        if (protoContent == null) {
            return null;
        }
        MessagePayload payload = new MessagePayload();
        payload.type = protoContent.getType();
        payload.searchableContent = protoContent.getSearchableContent();
        payload.pushContent = protoContent.getPushContent();
        payload.content = protoContent.getContent();
        if (protoContent.getData() != null && protoContent.getData().size() > 0) {
            payload.base64edData = Base64.getEncoder().encodeToString(protoContent.getData().toByteArray());
        }
        payload.mediaType = protoContent.getMediaType();
        payload.remoteMediaUrl = protoContent.getRemoteMediaUrl();
        payload.persistFlag = protoContent.getPersistFlag();
        payload.expireDuration = protoContent.getExpireDuration();
        payload.mentionedType = protoContent.getMentionedType();
        payload.mentionedTarget = new ArrayList<String>();
        payload.mentionedTarget.addAll(protoContent.getMentionedTargetList());
        payload.extra = protoContent.getExtra();
        payload.pushData = protoContent.getPushData();
        return payload;
    }
}

