package com.bcxin.risk.log;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import lombok.Data;

import java.io.Serializable;

/**
 * 审计操作日志
 * 需根据系统配置是否记录
 */
@Data
@TableName("log_audit")
public class AuditLogM extends Model<AuditLogM> {

    private static final long serialVersionUID = 1L;

    @TableId(type = IdType.AUTO)
    private Long oid;

    /**
     * 流水号
     */
    private String num_id;

    /**
     * 用户标识
     */
    private String user_id;

    /**
     * 单位名称
     */
    private String organization;

    /**
     * 用户名
     */
    private String user_name;

    /**
     * 终端标识
     */
    private String terminal_id;

    /**
     * 操作名称
     */
    private String operate_name;

    /**
     * 操作类型
     */
    private int operate_type;

    /**
     * 操作时间
     */
    private String operate_time;

    /**
     * 操作条件
     */
    private String operate_condition;

    /**
     * 操作结果
     */
    private String operate_result;
    private String bz1;
    private String bz2;
    private String bz3;
    private String bz4;
    private String bz5;

    @Override
    public Serializable pkVal() {
        return this.oid;
    }
}
