package com.bcxin.hb.hbzw;

import com.baomidou.mybatisplus.extension.activerecord.Model;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.Date;

/**
 * 受理信息表
 * @author wangjianjun
 * @date 2020/8/17
 */
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
public class PreAccept extends Model<PreAccept> {
    /**
     * 办件编号
     */
    private String PROJID;

    /**
     * 版本号
     */
    private Integer DATAVERSION;

    /**
     * 受理人员（政务服务人员）
     */
    private String ACCEPT_MAN;

    /**
     * 受理时间
     */
    private Date ACCEPT_TIME;

    /**
     * 承诺期限
     */
    private String PROMISEVALUE;

    /**
     * 承诺期限单位
     */
    private String PROMISETYPE;

    /**
     * 承诺办结时间
     */
    private Date PROMISE_ETIME;

    /**
     * 所属系统
     */
    private String BELONGSYSTEM;

    /**
     * 备用字段
     */
    private String EXTEND;

    /**
     * 数据产生时间
     */
    private Date CREATE_TIME;

    private String SYNC_STATUS;

    /**
     * 政务服务人员所在部门名称
     */
    private String HANDER_DEPTNAME;

    /**
     * 受理文书编号
     */
    private String DOCUMENT_CODE;

    /**
     * 受理人员所属部门编码
     */
    private String HANDER_DEPTID;

    /**
     * 受理人员所属部门的所在行政区划编码
     */
    private String AREACODE;

    /**
     * 业务数据交换时间戳
     */
    private Date JH_SJC_DXP;

    /**
     * 业务数据状态
     */
    private String JH_SJZT;

    /**
     * 业务数据上传机构标识
     */
    private String JH_SCJG;

    /**
     * 业务数据上传机构名称
     */
    private String JH_SCJGMC;

    /**
     * 业务数据目标机构标识
     */
    private String JH_MBJG;

    /**
     * 1推送到一窗大厅，0推送到厅局
     */
    private String JH_YCBJ;

    @Override
    public Serializable pkVal() {
        return null;
    }
}