package com.bcxin.risk.user.dto.data;

import com.bcxin.risk.user.domain.User;
import lombok.Data;

@Data
public class UserDto {

	private String oid; // 用户ID

	private String active; // 是否激活

	private String userName; //用户名

	private String realName; //真实姓名

	private String password; //密码

	private String encryptPwd;//密码是否已加密

	private String phone; // 手机号码

	private String companyPhone; // 企业联系方式

	private String email; //邮箱

	private String userType; //用户类型

	private String validateCode; //秘钥

	private String orgAdmin ; //是否机构管理员 0: 否 ，1：是

	private String org_id; //机构ID

	private String ipAddress;

	private String address;//单位联系地址

	private String companyName;

	private Long area_id;  // 区域ID

	private Long city_id;  // 城市ID

	private Long province_id;  // 省份ID

	private Long parent_id;  // 父级机构ID

	private String govOrgFlag; //政府单位标志

	private String isSync; // 同步标志

	private String ywzcId; // 业务支撑ID

	private String channel;

	private String zwId;

	/**
	 * 数据来源(空值:子站注册1:广西政务单点)
	 */
	private String dataSource;
	private transient String serviceOrg;//是否服务商

	public UserDto(){
	}

	public UserDto(User user){
		this.realName = user.getRealName();
		this.userName = user.getUserName();
		this.area_id = user.getArea_id();
		this.city_id = user.getCity_id();
		this.province_id = user.getProvince_id();
		this.phone = user.getPhone();
		this.userType = user.getUserType();
		this.email = user.getEmail();
		this.password = user.getPassword();
		this.active = user.getActive();
		this.channel = user.getChannel();
		this.dataSource = user.getDataSource();
	}



}
	
