package com.bcxin.risk.user.domain;

import com.bcxin.risk.base.domain.BaseBean;
import lombok.Data;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;

import javax.persistence.*;

/**
 * 用户角色表
 */
@Entity
@Table(name = "RISK_User_Role")
@Inheritance(strategy = InheritanceType.JOINED)
@Data
@DynamicInsert(true)
@DynamicUpdate(true)
public class UserRole extends BaseBean {

	private static final long serialVersionUID = 1L;

	@ManyToOne(targetEntity = User.class, fetch = FetchType.LAZY)
	@JoinColumn(name = "user_id")
	private User user; //所属用户

	@ManyToOne(targetEntity = Role.class, fetch = FetchType.LAZY)
	@JoinColumn(name = "role_id")
	private Role role; //所属角色

}
