package com.bcxin.risk.user.domain;

import com.bcxin.risk.base.domain.BaseBean;
import com.bcxin.risk.org.domain.Org;
import lombok.Data;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;

import javax.persistence.*;
import java.util.Date;

@Entity
@Table(name = "RISK_SE_USER")
@Inheritance(strategy = InheritanceType.JOINED)
@Data
@DynamicInsert(true)
@DynamicUpdate(true)
public class User extends BaseBean {

	private static final long serialVersionUID = 1L;

	/**
	 * 用户名
	 */
	private String userName;

	/**
	 * 姓名
	 */
	private String realName;

	/**
	 * 密码
	 */
	private String password;

	/**
	 * 邮箱
	 */
	private String email;

	/**
	 * 手机
	 */
	private String phone;

	/**
	 * 企业联系方式
	 */
	private String companyPhone;

	/**
	 * 是否是机构管理员；1代表是，0代表不是
	 */
	private String orgAdmin;

	/**
	 * 用户类型（承办，服务机构，专家，管理等）
	 */
	private String userType;

	/**
	 * 是否有效 0:无效，1:有效
	 */
	private String active;

	/** 找回密码 密钥**/
	private String validateCode;

	/**
	 * 过期时间
	 */
	@Temporal(TemporalType.TIMESTAMP)
	private Date overdueTime;

	/**
	 * 所属机构
	 */
	@ManyToOne(targetEntity = Org.class, fetch = FetchType.EAGER)
	@JoinColumn(name = "org_id")
	private Org org;
	/**
	 * 注册人ip
	 */
	private String ipAddress;

	private Long area_id;  // 区域ID

	private Long city_id;  // 城市ID

	private Long province_id;  // 省份ID

	private String isSync ; // 业务支撑同步标志 0:未同步，1:同步

	private String ywzcId ; // 业务支撑ID

	private String channel;//活动申请的渠道（sb_sn.dh.pss360.cn,代表申报子系统陕西环境）

	private String signature;//电子签名

	/**
	 * 数据来源(空值:子站注册1:广西政务单点)
	 */
	private String dataSource;

	/**
	 * 政务网对接时，政务系统的用户id
	 */
	private String zwId;
	/**
	 * 用户登陆后获得菜单
	 */
	@Transient
	private String allowMenus;

	//子站站点
	@Transient
	private String carryInfo;

	/**
	 * 密码修改时间
	 */
	private Date lastPasswordDate;
}
