package com.bcxin.risk.user.domain;

import com.bcxin.risk.base.domain.BaseBean;
import lombok.Data;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;

import javax.persistence.Entity;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.Table;

/**
 * 角色
 */
@Entity
@Table(name = "base_role")
@Inheritance(strategy = InheritanceType.JOINED)
@Data
@DynamicInsert(true)
@DynamicUpdate(true)
public class Role extends BaseBean {

	private static final long serialVersionUID = 1L;

	/**
	 * 角色代码
	 */
	private String roleCode;

	/**
	 * 角色名称
	 */
	private String roleName;

	/**
	 * 角色描述
	 */
	private String roleDesc;

	/**
	 * 机构类型（字典）
	 */
	private String orgType;

	/**
	 * 第三方服务机构机构类型（字典）
	 */
	private String serviceOrgType;

	/**
	 * 激活状态，1代表有效，0代表无效（字典）
	 */
	private String active;

}
