package com.bcxin.risk.user.domain;

import com.bcxin.risk.org.domain.ContractorOrg;
import lombok.Data;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;

import javax.persistence.*;

/**
 * 
 * <b>Function 服务机构用户</b>
 * 
 * @author LuoPeng
 * @date 2016年12月26日 下午2:39:34
 * @注意事项 </b>
 * <b>
 */
@Entity
@Table(name = "RISK_ContractorUser")
@Inheritance(strategy = InheritanceType.JOINED)
@Data
@DynamicInsert(true)
@DynamicUpdate(true)
public class ContractorUser extends User {

	private static final long serialVersionUID = 1L;

	@ManyToOne(targetEntity = ContractorOrg.class, fetch = FetchType.LAZY)
	@JoinColumn(name = "org_id")
	private ContractorOrg contractorOrg; //所属机构

	/**
	 * 是否首次登陆
	 */
	private String isFirstLogin;

}
