package com.bcxin.risk.train.dto;

import lombok.Data;

import java.util.Map;

@Data
public class VideoDTO {

    private String videoId;
    private String completed;


    public VideoDTO(Map<String,Object> map){
        this.videoId = safeTransfor(map.get("videoId"));
        this.completed = safeTransfor(map.get("completed"));
    }


    /**
     *
     * <b>Function 将Object安全转换为String</b>
     *
     * @param obj
     * @return
     * @author WangChenYi
     * @date 2017年05月08日 下午2:19:22
     * @注意事项 </b>
     * <b>
     */
    private static String safeTransfor(Object obj){
        if ( obj == null ) {
            return "";
        }
        return obj.toString();
    }

}
